/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class SearchSettingsPanel
extends JPanel {
    private JCheckBox ignorePrefixesCheckBox = new JCheckBox("Ignore prefixes for searching");
    private SelectableList list;
    private OWLModel owlModel;

    public SearchSettingsPanel(final OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.list = new SelectableList();
        this.list.setListData(oWLModel.getSearchSynonymProperties().toArray());
        this.list.setCellRenderer((ListCellRenderer)((Object)new ResourceRenderer()));
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Use search synonyms", new JScrollPane((Component)this.list));
        oWLLabeledComponent.addHeaderButton(new AbstractAction("Add property...", OWLIcons.getAddIcon("RDFProperty")){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchSettingsPanel.this.addProperty();
            }
        });
        oWLLabeledComponent.addHeaderButton((Action)new AllowableAction("Remove selected property", OWLIcons.getRemoveIcon("RDFProperty"), (Selectable)this.list){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchSettingsPanel.this.removeSelectedProperty();
            }
        });
        this.setLayout(new BorderLayout());
        Boolean bl = oWLModel.getOWLProject().getSettingsMap().getBoolean("OWL-TOLERATE-PREFIXES-IN-SEARCH");
        this.ignorePrefixesCheckBox.setSelected(Boolean.TRUE.equals(bl));
        this.ignorePrefixesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                oWLModel.getOWLProject().getSettingsMap().setBoolean("OWL-TOLERATE-PREFIXES-IN-SEARCH", SearchSettingsPanel.this.ignorePrefixesCheckBox.isSelected());
            }
        });
        this.add("North", this.ignorePrefixesCheckBox);
        this.add("Center", (Component)((Object)oWLLabeledComponent));
    }

    private void addProperty() {
        Collection collection = this.owlModel.getSearchSynonymProperties();
        Collection collection2 = this.owlModel.getRDFProperties();
        Object object = collection2.iterator();
        while (object.hasNext()) {
            RDFProperty rDFProperty = (RDFProperty)object.next();
            if (!collection.contains(rDFProperty) && rDFProperty.getValueType() == ValueType.STRING) continue;
            object.remove();
        }
        object = new HashSet(collection);
        object.addAll(ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection(this, this.owlModel, collection2, "Add search properties..."));
        this.owlModel.setSearchSynonymProperties((Collection)object);
        this.list.setListData(this.owlModel.getSearchSynonymProperties().toArray());
    }

    private void removeSelectedProperty() {
        Collection collection = this.owlModel.getSearchSynonymProperties();
        collection.removeAll(this.list.getSelection());
        this.owlModel.setSearchSynonymProperties(collection);
        this.list.setListData(this.owlModel.getSearchSynonymProperties().toArray());
    }
}

