/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.code;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelOrderedWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SourceCodePanel
extends JPanel {
    private JTextArea textArea;
    private JCheckBox useXMLEntitiesBox;
    private JComboBox tripleStoreCombo;
    private OWLModel owlModel;

    public SourceCodePanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.setLayout(new BorderLayout());
        this.useXMLEntitiesBox = new JCheckBox("Use XML Entities", XMLWriterPreferences.getInstance().isUseNamespaceEntities());
        this.useXMLEntitiesBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceCodePanel.this.writeSelectedTripleStore();
            }
        });
        ArrayList arrayList = new ArrayList(this.owlModel.getTripleStoreModel().getTripleStores());
        arrayList.remove(0);
        this.tripleStoreCombo = new JComboBox<Object>(arrayList.toArray());
        this.tripleStoreCombo.setSelectedItem(this.owlModel.getTripleStoreModel().getActiveTripleStore());
        this.tripleStoreCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceCodePanel.this.writeSelectedTripleStore();
            }
        });
        this.tripleStoreCombo.setRenderer(new TripleStoreListCellRenderer());
        JPanel jPanel = new JPanel(new BorderLayout(7, 7));
        jPanel.add((Component)this.tripleStoreCombo, "North");
        jPanel.add((Component)this.useXMLEntitiesBox, "South");
        this.add((Component)jPanel, "North");
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Courier New", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        LabeledComponent labeledComponent = new LabeledComponent("Source Code", jScrollPane);
        this.add("Center", (Component)labeledComponent);
        this.setPreferredSize(new Dimension(760, 600));
        this.writeSelectedTripleStore();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceCodePanel.this.textArea.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
    }

    private void writeSelectedTripleStore() {
        StringWriter stringWriter = new StringWriter();
        XMLWriterPreferences.getInstance().setUseNamespaceEntities(this.useXMLEntitiesBox.isSelected());
        TripleStore tripleStore = (TripleStore)this.tripleStoreCombo.getSelectedItem();
        OWLModelOrderedWriter oWLModelOrderedWriter = new OWLModelOrderedWriter(this.owlModel, tripleStore, stringWriter);
        try {
            oWLModelOrderedWriter.write();
        }
        catch (IOException iOException) {
            ProtegeUI.getModalDialogFactory().showThrowable(this.owlModel, iOException);
        }
        String string = stringWriter.toString();
        this.textArea.setText(string);
    }

    private class TripleStoreListCellRenderer
    extends DefaultListCellRenderer {
        private TripleStoreListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            TripleStore tripleStore = (TripleStore)object;
            String string = tripleStore.getName();
            if (string == null) {
                string = "<Main File>";
            }
            jLabel.setText(string);
            return jLabel;
        }
    }
}

