/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix;

import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.matrix.AbstractMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.EditableMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.SortableMatrixColumn;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class NameMatrixColumn
extends AbstractMatrixColumn
implements EditableMatrixColumn,
SortableMatrixColumn {
    public NameMatrixColumn() {
        super("Name", 250);
    }

    public TableCellRenderer getCellRenderer() {
        return new FrameRenderer(){

            public void load(Object object) {
                if (object instanceof RDFResource) {
                    RDFResource rDFResource = (RDFResource)object;
                    this.setGrayedText(false);
                    this.addIcon(ProtegeUI.getIcon(rDFResource));
                    this.addText(rDFResource.getLocalName());
                } else {
                    super.load(object);
                }
            }
        };
    }

    public Comparator getSortComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                RDFResource rDFResource = (RDFResource)object;
                RDFResource rDFResource2 = (RDFResource)object2;
                int n = rDFResource.getLocalName().compareTo(rDFResource2.getLocalName());
                if (n == 0) {
                    return rDFResource.getName().compareTo(rDFResource2.getName());
                }
                return n;
            }
        };
    }

    public TableCellEditor getTableCellEditor() {
        JTextField jTextField = new JTextField();
        return new DefaultCellEditor(jTextField){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                RDFResource rDFResource = (RDFResource)object;
                return super.getTableCellEditorComponent(jTable, rDFResource.getLocalName(), bl, n, n2);
            }
        };
    }

    public boolean isCellEditable(RDFResource rDFResource) {
        return true;
    }

    public void setValueAt(RDFResource rDFResource, Object object) {
        String string = rDFResource.getLocalName();
        if (!string.equals(object)) {
            String string2 = rDFResource.getNamespacePrefix();
            string2 = string2 == null ? (String)object : string2 + ":" + object;
            RDFResource rDFResource2 = rDFResource.getOWLModel().getRDFResource(string2);
            if (rDFResource2 != null && !rDFResource2.equals(rDFResource)) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(rDFResource.getOWLModel(), "The name \"" + string2 + "\" is already used", "Rename failed");
            } else if (rDFResource.getOWLModel().isValidResourceName(string2, rDFResource)) {
                rDFResource.setName(string2);
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(rDFResource.getOWLModel(), "\"" + string2 + "\" is not a valid name\nfor " + rDFResource.getBrowserText(), "Rename failed");
            }
        }
    }
}

