/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.jena;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.URIField;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.OWLFilesPlugin;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractOWLFilesWizardPage
extends WizardPage {
    private boolean callback = false;
    public static final String EXTENSION = "owl";
    private URIField owlFileURIField;
    private OWLFilesPlugin plugin;
    private static String HELP_TEXT = "<P>Please specify either a local file or the URL of an online ontology which you want to load.  You can search for a <B>file</B> using the Browse button in the upper right corner.  For <B>online ontologies</B>, you could copy and paste the URL from an internet browser.</P>";

    public AbstractOWLFilesWizardPage(Wizard wizard, OWLFilesPlugin oWLFilesPlugin, String string) {
        super(string, wizard);
        this.plugin = oWLFilesPlugin;
        this.owlFileURIField = new URIField("OWL file name or URL", null, EXTENSION, "Web Ontology Language (OWL) files");
        this.owlFileURIField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AbstractOWLFilesWizardPage.this.updateSetPageComplete();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(8, 8));
        jPanel.add("North", (Component)this.owlFileURIField);
        jPanel.add("South", OWLUI.createHelpPanel(HELP_TEXT, "How to load an OWL Ontology?", 160));
        this.add(jPanel);
        this.updateSetPageComplete();
    }

    protected OWLFilesPlugin getPlugin() {
        return this.plugin;
    }

    public String getProjectPath() {
        String string = "";
        if (string == null) {
            if (this.owlFileURIField != null) {
                URI uRI = this.owlFileURIField.getAbsoluteURI();
                if (uRI != null) {
                    string = uRI.toString();
                    string = FileUtilities.replaceExtension((String)string, (String)".pprj");
                } else {
                    string = "";
                }
            } else {
                string = "";
            }
        }
        return string;
    }

    private URI getURI(String string) {
        try {
            return new URI(string);
        }
        catch (Exception exception) {
            return URIUtilities.createURI((String)string);
        }
    }

    public void onFinish() {
        this.plugin.setLanguage("RDF/XML-ABBREV");
        URI uRI = this.owlFileURIField.getAbsoluteURI();
        String string = uRI != null ? uRI.toString() : "";
        this.plugin.setFile(string);
    }

    protected void onProjectPathChange(String string, String string2) {
        if (string2 != null) {
            this.updatePath(string2);
        }
    }

    private void updatePath(String string) {
        if (this.getProjectPath() != null && !this.callback) {
            String string2 = "RDF/XML-ABBREV";
            String string3 = "." + JenaKnowledgeBaseFactory.getExtension(string2);
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            String string4 = new File(string).getName();
            String string5 = FileUtilities.replaceExtension((String)string4, (String)string3);
            this.owlFileURIField.setURI(this.getURI(string5));
        }
    }

    public boolean validateContents() {
        if (this.owlFileURIField.getRelativeURI() == null) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog((Component)((Object)this), "You need to enter a valid URI for an OWL/RDF file.\nCurrently, these URIs should not contain spaces.");
            return false;
        }
        return true;
    }

    private void updateSetPageComplete() {
        this.setPageComplete(this.owlFileURIField.getRelativeURI() != null);
    }
}

