/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.forms;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteFormsGenerator;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteLayoutNames;
import edu.stanford.smi.protegex.owl.ui.forms.FormsNames;
import edu.stanford.smi.protegex.owl.ui.forms.ProtegeFormsNames;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;

public class AbsoluteFormsLoader {
    private OWLModel owlModel;
    private Project project;

    public AbsoluteFormsLoader(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.project = oWLModel.getProject();
    }

    public void load(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this.load(inputStream);
    }

    public void load(InputStream inputStream) throws IOException {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read(inputStream, "http://dummy.de/aldi.owl", "RDF/XML-ABBREV");
        inputStream.close();
        ontModel.add((Resource)FormsNames.FormWidget, RDF.type, (RDFNode)OWL.Class);
        OntClass ontClass = ontModel.getOntClass(FormsNames.FormWidget.getURI());
        ExtendedIterator extendedIterator = ontClass.listInstances();
        while (extendedIterator.hasNext()) {
            Resource resource = (Resource)extendedIterator.next();
            this.addFormWidget(resource);
        }
        this.project.clearCachedWidgets();
    }

    public void loadAll() throws Exception {
        File file = new File(ProtegeOWL.getPluginFolder(), "protege-system.forms");
        if (file.exists()) {
            System.out.println("Loading system forms from " + file);
            this.load(new FileInputStream(file));
        }
        Iterator iterator = this.owlModel.getTripleStoreModel().listUserTripleStores();
        while (iterator.hasNext()) {
            TripleStore tripleStore = (TripleStore)iterator.next();
            URI uRI = new URI(tripleStore.getName());
            Repository repository = this.owlModel.getRepositoryManager().getRepository(uRI);
            String string = AbsoluteFormsGenerator.getFormsFileURI(tripleStore, this.owlModel);
            URI uRI2 = new URI(string);
            if (repository != null) {
                if (!repository.contains(uRI2)) continue;
                System.out.println("Adding forms from " + uRI2);
                this.load(repository.getInputStream(uRI2));
                continue;
            }
            try {
                File file2 = null;
                if (tripleStore == this.owlModel.getTripleStoreModel().getTopTripleStore()) {
                    string = ((JenaOWLModel)this.owlModel).getOWLFilePath() + ".forms";
                    file2 = new File(string);
                } else {
                    file2 = new File(uRI2);
                }
                if (!file2.exists()) continue;
                System.out.println("Adding forms from " + file2);
                this.load(new FileInputStream(file2));
            }
            catch (Exception exception) {}
        }
    }

    private void addFormWidget(Resource resource) {
        Cls cls;
        String string;
        String string2;
        Statement statement = resource.getProperty((Property)FormsNames.forClass);
        if (statement != null && (string2 = this.owlModel.getResourceNameForURI(string = statement.getResource().getURI())) != null && (cls = this.project.getKnowledgeBase().getCls(string2)) != null) {
            ClsWidget clsWidget = this.project.getDesignTimeClsWidget(cls);
            WidgetDescriptor widgetDescriptor = clsWidget.getDescriptor();
            widgetDescriptor.setDirectlyCustomizedByUser(true);
            PropertyList propertyList = widgetDescriptor.getPropertyList();
            StmtIterator stmtIterator = resource.listProperties((Property)FormsNames.widgets);
            while (stmtIterator.hasNext()) {
                Statement statement2 = stmtIterator.nextStatement();
                if (statement2.getResource() == null) continue;
                Resource resource2 = statement2.getResource();
                this.addFormWidget(clsWidget, resource2);
            }
        }
    }

    private void addFormWidget(ClsWidget clsWidget, Resource resource) {
        String string;
        String string2;
        Statement statement = resource.getProperty((Property)FormsNames.forProperty);
        String string3 = null;
        if (statement != null) {
            string2 = statement.getResource().getURI();
            string = this.owlModel.getResourceNameForURI(string2);
            if (string != null && this.owlModel.getRDFResource(string) instanceof RDFProperty) {
                string3 = string;
            }
        } else {
            string2 = resource.getProperty(RDFS.comment);
            string3 = string2 != null ? string2.getString() : "protege:inferredType";
        }
        if (string3 != null) {
            string2 = this.project.getKnowledgeBase().getSlot(string3);
            string = this.getWidgetClassName(resource);
            if (string != null) {
                clsWidget.replaceWidget((Slot)string2, string);
                SlotWidget slotWidget = clsWidget.getSlotWidget((Slot)string2);
                this.setWidgetBounds(slotWidget.getDescriptor(), resource);
            }
        }
    }

    private int getInt(Resource resource, Property property) {
        Statement statement = resource.getProperty(property);
        if (statement != null) {
            return statement.getInt();
        }
        return 0;
    }

    private String getWidgetClassName(Resource resource) {
        Resource resource2;
        Statement statement;
        Statement statement2 = resource.getProperty(RDF.type);
        if (statement2 != null && (statement = (resource2 = statement2.getResource()).getProperty((Property)ProtegeFormsNames.javaClassName)) != null) {
            return statement.getString();
        }
        return null;
    }

    private void setWidgetBounds(WidgetDescriptor widgetDescriptor, Resource resource) {
        StmtIterator stmtIterator = resource.listProperties((Property)FormsNames.layoutData);
        while (stmtIterator.hasNext()) {
            Resource resource2;
            Statement statement = (Statement)stmtIterator.next();
            if (statement.getResource() == null || !(resource2 = statement.getResource()).hasProperty(RDF.type, (RDFNode)AbsoluteLayoutNames.AbsoluteLayoutData)) continue;
            int n = this.getInt(resource2, (Property)AbsoluteLayoutNames.x);
            int n2 = this.getInt(resource2, (Property)AbsoluteLayoutNames.y);
            int n3 = this.getInt(resource2, (Property)AbsoluteLayoutNames.width);
            int n4 = this.getInt(resource2, (Property)AbsoluteLayoutNames.height);
            widgetDescriptor.setBounds(new Rectangle(n, n2, n3, n4));
        }
    }

    public static void main(String[] stringArray) throws Exception {
        JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModelFromInputStream(new FileInputStream("travel.owl"));
        AbsoluteFormsLoader absoluteFormsLoader = new AbsoluteFormsLoader(jenaOWLModel);
        absoluteFormsLoader.load(new File("travel.owl.forms").toURL());
    }

    public static boolean useNewFormMechanism_DontUseThisMethod() {
        return ApplicationProperties.getBooleanProperty((String)"NewOWLFormsMechanism", (boolean)false);
    }
}

