/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreePanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;

public class ExistentialAction
extends ResourceSelectionAction {
    private OWLNamedClass cls;
    private Component component;
    private HierarchyManager hierarchyManager;

    public ExistentialAction(Component component, HierarchyManager hierarchyManager, OWLNamedClass oWLNamedClass) {
        super("Explore existential relationships...", OWLIcons.getImageIcon("Transitivity"));
        this.cls = oWLNamedClass;
        this.component = component;
        this.hierarchyManager = hierarchyManager;
    }

    public void resourceSelected(RDFResource rDFResource) {
        if (rDFResource instanceof OWLObjectProperty) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)rDFResource;
            ExistentialTreePanel existentialTreePanel = new ExistentialTreePanel(this.cls, this.cls.getOWLModel().getSlot(":DIRECT-SUPERCLASSES"), oWLObjectProperty);
            this.hierarchyManager.addHierarchy(existentialTreePanel);
        }
    }

    public Collection getSelectableResources() {
        OWLModel oWLModel = this.cls.getOWLModel();
        ArrayList arrayList = new ArrayList(oWLModel.getVisibleUserDefinedOWLProperties());
        ArrayList<OWLProperty> arrayList2 = new ArrayList<OWLProperty>();
        for (OWLProperty oWLProperty : arrayList) {
            if (!(oWLProperty instanceof OWLObjectProperty)) continue;
            arrayList2.add(oWLProperty);
        }
        return arrayList2;
    }

    public RDFResource pickResource() {
        Collection collection = this.getSelectableResources();
        return (OWLObjectProperty)ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(this.component, this.cls.getOWLModel(), collection, "Select a property to explore");
    }

    public void setCls(OWLNamedClass oWLNamedClass) {
        this.cls = oWLNamedClass;
    }
}

