/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTable;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTable;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableTransferHandler;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import javax.swing.JTable;

public class ConditionsTableTransferHandler
extends OWLTableTransferHandler
implements ConditionsTableConstants {
    private String movedClsText;
    private String movedClsBlock;
    private boolean movedClsWasDefinition;
    private OWLNamedClass movedNamedCls;
    private boolean movedNamedClsHadThingAsSuperClass;
    private int recentTargetRow;
    private int recentTargetType;
    public Transferable recentTransferable;

    public ConditionsTableTransferHandler(OWLModel oWLModel) {
        super(oWLModel);
    }

    protected boolean addRow(OWLTableModel oWLTableModel, RDFSClass rDFSClass, int n) {
        this.recentTargetType = ((ConditionsTableModel)oWLTableModel).getType(n);
        return ((ConditionsTableModel)oWLTableModel).addRowAllowMove(rDFSClass, n);
    }

    public void cleanup(JComponent jComponent, boolean bl) {
        OWLTable oWLTable = (OWLTable)((Object)jComponent);
        OWLClassesTab oWLClassesTab = ((ConditionsTable)oWLTable).getOWLClsesTab();
        if (bl && this.rows != null) {
            this.cleanup(oWLTable);
            this.movedClsBlock = null;
            this.movedClsText = null;
            this.recentTargetType = -10;
        }
        ((ConditionsTable)oWLTable).ensureEditedClassSelectedInExplorer(oWLClassesTab);
        super.cleanup(jComponent, bl);
        this.movedNamedCls = null;
    }

    private void cleanup(OWLTable oWLTable) {
        int n;
        ConditionsTableModel conditionsTableModel = (ConditionsTableModel)oWLTable.getModel();
        String string = null;
        int n2 = oWLTable.getSelectedRow();
        if (n2 >= 0 && conditionsTableModel.getClass(n2) != null) {
            string = conditionsTableModel.getClass(n2).getBrowserText();
        }
        if ((n = this.getDeleteRowIndex(conditionsTableModel)) >= 0) {
            if (conditionsTableModel.isDefinition(n) && conditionsTableModel.getClass(n) instanceof OWLNamedClass && this.recentTargetType == -1 && conditionsTableModel.getDefinition(n) == null) {
                RDFSClass rDFSClass = conditionsTableModel.getClass(n);
                rDFSClass.removeDirectSuperclass(conditionsTableModel.getEditedCls());
            } else {
                conditionsTableModel.deleteRow(n, true);
            }
            if (this.movedNamedCls != null && this.recentTargetType == -1) {
                conditionsTableModel.getEditedCls().addSuperclass(this.movedNamedCls);
                if (!this.movedNamedClsHadThingAsSuperClass) {
                    conditionsTableModel.getEditedCls().removeSuperclass(this.getRootCls());
                }
            }
            if (this.movedNamedCls != null && this.recentTargetRow == 0) {
                conditionsTableModel.getEditedCls().addEquivalentClass(this.movedNamedCls);
                if (!this.movedNamedClsHadThingAsSuperClass) {
                    conditionsTableModel.getEditedCls().removeSuperclass(this.getRootCls());
                }
            }
        }
        if (string != null) {
            oWLTable.setSelectedRow(string);
        }
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        ConditionsTable conditionsTable = (ConditionsTable)((Object)jComponent);
        ConditionsTableModel conditionsTableModel = (ConditionsTableModel)conditionsTable.getModel();
        int n2 = conditionsTable.getSelectedRow();
        if (n2 >= 0 && conditionsTableModel.getClass(n2) instanceof OWLNamedClass && conditionsTableModel.isDefinition(n2)) {
            this.movedNamedCls = (OWLNamedClass)conditionsTableModel.getClass(n2);
            this.movedNamedClsHadThingAsSuperClass = conditionsTableModel.getEditedCls().getSuperclasses(false).contains(this.getRootCls());
        }
        super.exportAsDrag(jComponent, inputEvent, n);
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        this.movedNamedCls = null;
        super.exportToClipboard(jComponent, clipboard, n);
    }

    protected Transferable exportOWLClses(JComponent jComponent) {
        JTable jTable = (JTable)jComponent;
        ConditionsTableModel conditionsTableModel = (ConditionsTableModel)jTable.getModel();
        int n = jTable.getSelectedRow();
        if (n >= 0 && conditionsTableModel.getClass(n) != null && conditionsTableModel.getType(n) != -2) {
            this.movedClsText = conditionsTableModel.getClass(n).getBrowserText();
            this.movedClsBlock = conditionsTableModel.getBlockText(conditionsTableModel.getType(n));
            this.movedClsWasDefinition = conditionsTableModel.isDefinition(n);
        }
        this.recentTransferable = super.exportOWLClses(jComponent);
        return this.recentTransferable;
    }

    private int getDeleteRowIndex(ConditionsTableModel conditionsTableModel) {
        int n = -1;
        if (this.movedClsWasDefinition) {
            if (this.movedClsBlock == null) {
                return -1;
            }
            n = 0;
            while (!this.movedClsBlock.equals(conditionsTableModel.getBlockText(n))) {
                ++n;
            }
        }
        for (int i = 0; i < conditionsTableModel.getRowCount(); ++i) {
            RDFSClass rDFSClass = conditionsTableModel.getClass(i);
            if (rDFSClass == null || conditionsTableModel.getType(i) != n || !rDFSClass.getBrowserText().equals(this.movedClsText)) continue;
            return i;
        }
        return -1;
    }

    protected int importOWLClses(JComponent jComponent, String string) {
        ConditionsTable conditionsTable = (ConditionsTable)((Object)jComponent);
        this.recentTargetRow = conditionsTable.getSelectedRow();
        OWLClassesTab oWLClassesTab = ((ConditionsTable)((Object)jComponent)).getOWLClsesTab();
        int n = super.importOWLClses(jComponent, string);
        ((ConditionsTable)((Object)jComponent)).ensureEditedClassSelectedInExplorer(oWLClassesTab);
        return n;
    }
}

