/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.actions.CopyPropertyValueAction;
import edu.stanford.smi.protegex.owl.ui.actions.DeleteAllPropertyValuesAction;
import edu.stanford.smi.protegex.owl.ui.actions.DeleteMatchingPropertyValuesAction;
import edu.stanford.smi.protegex.owl.ui.actions.triple.TripleAction;
import edu.stanford.smi.protegex.owl.ui.actions.triple.TripleActionManager;
import edu.stanford.smi.protegex.owl.ui.actions.triple.TripleActionSwingAction;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.results.TripleDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TriplesTable
extends JTable
implements TripleDisplay {
    private TriplesTableModel tableModel;
    private JTextField textField;
    private JComboBox typeComboBox;

    public TriplesTable(Project project, TriplesTableModel triplesTableModel, final String string) {
        super(triplesTableModel);
        this.tableModel = triplesTableModel;
        triplesTableModel.setTable(this);
        this.textField = new JTextField();
        OWLUI.addCopyPastePopup(this.textField);
        this.setDefaultEditor(Object.class, new DefaultCellEditor(this.textField));
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.getColumnModel().getColumn(this.tableModel.getColumnCount() - 1);
        tableColumn.setCellRenderer((TableCellRenderer)new FrameRenderer());
        tableColumn2.setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
        OWLModel oWLModel = (OWLModel)project.getKnowledgeBase();
        JComboBox jComboBox = ComponentUtil.createLangCellEditor(oWLModel, this);
        tableColumn3.setCellEditor(new DefaultCellEditor(jComboBox));
        if (this.tableModel.hasTypeColumn()) {
            TableColumn tableColumn4 = this.getColumnModel().getColumn(this.tableModel.getColumnCount() - 2);
            tableColumn4.setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
            Vector vector = new Vector();
            this.typeComboBox = new JComboBox(vector);
            this.typeComboBox.setRenderer(new ResourceRenderer());
            tableColumn4.setCellEditor(new DefaultCellEditor(this.typeComboBox));
        }
        this.setAutoResizeMode(4);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setSelectionMode(0);
        tableColumn.setPreferredWidth(100);
        tableColumn2.setPreferredWidth(200);
        tableColumn3.setPreferredWidth(60);
        tableColumn3.setMaxWidth(100);
        this.addMouseListener((MouseListener)new PopupMenuMouseListener(this){

            protected JPopupMenu getPopupMenu() {
                return TriplesTable.this.createPopupMenu(string);
            }

            protected void setSelection(JComponent jComponent, int n, int n2) {
                int n3 = n2 / TriplesTable.this.getRowHeight();
                if (n3 >= 0 && n3 < TriplesTable.this.getRowCount()) {
                    TriplesTable.this.getSelectionModel().setSelectionInterval(n3, n3);
                }
            }
        });
    }

    protected JPopupMenu createPopupMenu(String string) {
        ArrayList arrayList;
        TriplesTableModel triplesTableModel = (TriplesTableModel)this.getModel();
        RDFResource rDFResource = triplesTableModel.getSubject();
        final JPopupMenu jPopupMenu = new JPopupMenu();
        int n = this.getSelectedRow();
        RDFProperty rDFProperty = triplesTableModel.getPredicate(n);
        Object object = triplesTableModel.getValue(n);
        if (rDFProperty.isAnnotationProperty()) {
            if (rDFResource instanceof RDFSNamedClass) {
                arrayList = (RDFSNamedClass)rDFResource;
                ArrayList<RDFSClass> arrayList2 = new ArrayList<RDFSClass>();
                for (RDFSClass rDFSClass : arrayList.getSubclasses(true)) {
                    if (!(rDFSClass instanceof RDFSNamedClass)) continue;
                    arrayList2.add(rDFSClass);
                }
                jPopupMenu.add(new CopyPropertyValueAction("subclasses", rDFProperty, object, arrayList2, string));
                jPopupMenu.add(new DeleteMatchingPropertyValuesAction("subclasses", rDFProperty, object, arrayList2, string));
                jPopupMenu.add(new DeleteAllPropertyValuesAction("subclasses", rDFProperty, arrayList2, string));
            } else if (rDFResource instanceof RDFProperty) {
                arrayList = new ArrayList(((RDFProperty)rDFResource).getSubproperties(true));
                jPopupMenu.add(new CopyPropertyValueAction("subproperties", rDFProperty, object, arrayList, string));
                jPopupMenu.add(new DeleteMatchingPropertyValuesAction("subproperties", rDFProperty, object, arrayList, string));
                jPopupMenu.add(new DeleteAllPropertyValuesAction("subproperties", rDFProperty, arrayList, string));
            }
        }
        arrayList = new DefaultTriple(triplesTableModel.getSubject(), rDFProperty, object);
        TripleActionManager.addTripleActionsToMenu(arrayList, new TripleActionManager.Adder((Triple)((Object)arrayList)){
            final /* synthetic */ Triple val$triple;
            {
                this.val$triple = triple;
            }

            public void addTripleAction(TripleAction tripleAction) {
                jPopupMenu.add(new TripleActionSwingAction(tripleAction, this.val$triple));
            }
        });
        if (jPopupMenu.getComponentCount() > 0) {
            return jPopupMenu;
        }
        return null;
    }

    public boolean displayTriple(Triple triple) {
        int n;
        if (triple.getSubject().equals(this.tableModel.getSubject()) && (n = this.tableModel.getPropertyValueRow(triple.getPredicate(), triple.getObject())) >= 0) {
            this.getSelectionModel().setSelectionInterval(n, n);
            this.scrollRectToVisible(this.getCellRect(n, 0, false));
        }
        return false;
    }

    public void editCell(final int n) {
        this.getSelectionModel().setSelectionInterval(n, n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TriplesTable.this.scrollRectToVisible(TriplesTable.this.getCellRect(n, 1, true));
                TriplesTable.this.textField.requestFocus();
            }
        });
        this.editCellAt(n, 1);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TriplesTableModel triplesTableModel = (TriplesTableModel)this.getModel();
        RDFProperty rDFProperty = triplesTableModel.getPredicate(n);
        RDFResource rDFResource = rDFProperty.getRange();
        if (rDFProperty.getOWLModel().getXSDboolean().equals(rDFResource)) {
            JComboBox<Boolean> jComboBox = new JComboBox<Boolean>(new Boolean[]{Boolean.FALSE, Boolean.TRUE});
            return new DefaultCellEditor(jComboBox);
        }
        if (rDFResource instanceof OWLDataRange) {
            List list = ((OWLDataRange)rDFResource).getOneOfValues();
            JComboBox<Object> jComboBox = new JComboBox<Object>(list.toArray());
            return new DefaultCellEditor(jComboBox);
        }
        return super.getCellEditor(n, n2);
    }

    public TriplesTableModel getTableModel() {
        return this.tableModel;
    }

    public void setValueAt(Object object, int n, int n2) {
        RDFProperty rDFProperty = this.tableModel.getPredicate(n);
        Object object2 = this.tableModel.setValueAndGetIt(object, n, n2);
        this.setSelectedRow(rDFProperty, object2);
    }

    private void setSelectedRow(RDFProperty rDFProperty, Object object) {
        int n = this.getSelectedRow();
        int n2 = this.tableModel.getPropertyValueRow(rDFProperty, object);
        if (n2 >= 0) {
            n = n2;
        }
        if (n >= 0 && n < this.tableModel.getRowCount()) {
            this.getSelectionModel().setSelectionInterval(n, n);
        }
    }
}

