/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.multiresource;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;

public class MultiResourceListModel
extends AbstractListModel {
    private RDFProperty predicate;
    private RDFResource subject;
    private List values = new ArrayList();

    public MultiResourceListModel(RDFProperty rDFProperty) {
        this.predicate = rDFProperty;
    }

    public Object getElementAt(int n) {
        return this.values.get(n);
    }

    public RDFProperty getPredicate() {
        return this.predicate;
    }

    public RDFResource getResourceAt(int n) {
        return (RDFResource)this.getElementAt(n);
    }

    public int getRowOf(Object object) {
        return this.values.indexOf(object);
    }

    public int getSize() {
        return this.values.size();
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public boolean isEditable(int n) {
        TripleStoreModel tripleStoreModel = this.subject.getOWLModel().getTripleStoreModel();
        Object object = this.getElementAt(n);
        return tripleStoreModel.isEditableTriple(this.subject, this.predicate, object);
    }

    public boolean isRDFResource(int n) {
        return this.getElementAt(n) instanceof RDFResource;
    }

    public void setSubject(RDFResource rDFResource) {
        this.subject = rDFResource;
        this.updateValues();
    }

    public void updateValues() {
        this.fireIntervalRemoved(this, 0, this.values.size());
        this.values = new ArrayList(this.subject.getPropertyValues(this.predicate, true));
        Collection collection = this.subject.getHasValuesOnTypes(this.predicate);
        for (Object e : collection) {
            if (!(e instanceof RDFResource) || this.values.contains(e)) continue;
            this.values.add(e);
        }
        this.fireIntervalAdded(this, 0, this.values.size());
    }
}

