/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.multiresource;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.components.AddResourceAction;
import edu.stanford.smi.protegex.owl.ui.components.AddablePropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.multiresource.MultiResourceList;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultiResourceComponent
extends AddablePropertyValuesComponent {
    private Action createAction;
    private MultiResourceList list;
    private Action removeAction = new AbstractAction("Remove selected values", OWLIcons.getRemoveIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent actionEvent) {
            MultiResourceComponent.this.handleRemove();
        }
    };

    public MultiResourceComponent(RDFProperty rDFProperty, boolean bl) {
        super(rDFProperty);
        AddResourceAction addResourceAction;
        this.list = new MultiResourceList(rDFProperty, bl);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MultiResourceComponent.this.updateActions();
            }
        });
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent(this.getLabel(), new JScrollPane((Component)((Object)this.list)));
        this.createAction = this.createCreateAction();
        if (this.createAction != null) {
            oWLLabeledComponent.addHeaderButton(this.createAction);
        }
        if ((addResourceAction = this.createAddAction(bl)) != null) {
            oWLLabeledComponent.addHeaderButton(addResourceAction);
        }
        oWLLabeledComponent.addHeaderButton(this.removeAction);
        this.add("Center", (Component)((Object)oWLLabeledComponent));
        this.updateActions();
    }

    protected AddResourceAction createAddAction(boolean bl) {
        return new AddResourceAction(this, bl);
    }

    protected Action createCreateAction() {
        return new AbstractAction("Create new resource...", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiResourceComponent.this.list.handleCreate();
            }
        };
    }

    protected Object[] getSelectedObjects() {
        return this.list.getSelectedValues();
    }

    protected void handleRemove() {
        this.list.handleRemove();
    }

    public boolean isCreateEnabled() {
        return !this.isEnumerationProperty();
    }

    public void setSubject(RDFResource rDFResource) {
        super.setSubject(rDFResource);
        this.list.getListModel().setSubject(rDFResource);
        this.updateActions();
    }

    public void valuesChanged() {
        this.list.getListModel().updateValues();
    }

    private void updateActions() {
        if (this.createAction != null) {
            this.createAction.setEnabled(this.isCreateEnabled());
        }
        this.removeAction.setEnabled(this.list.isRemoveEnabled());
    }
}

