/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableCellHolder;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.View;

public class AnnotationsValueRenderer
implements TableCellRenderer {
    private JTextArea textArea = new JTextArea();
    private JLabel label;
    private JLabel langLabel;
    public static final int EXTRA_SPACING = 4;
    private AnnotationsTableCellHolder resourceHolder;
    private AnnotationsTableCellHolder plainTextPropertyValHolder;
    private AnnotationsTableCellHolder langHolder;

    public AnnotationsValueRenderer() {
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setFocusable(true);
        this.textArea.setOpaque(false);
        this.plainTextPropertyValHolder = new AnnotationsTableCellHolder(this.textArea, "Center");
        this.label = new JLabel();
        this.label.setOpaque(false);
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            this.label.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        }
        this.resourceHolder = new AnnotationsTableCellHolder(this.label, "North");
        this.langLabel = new JLabel();
        this.langHolder = new AnnotationsTableCellHolder(this.langLabel, "North");
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (!(jTable.getEditingRow() == n && jTable.getEditingColumn() == 1)) {
            int n3 = this.getRowHeight(jTable, n);
            if (jTable.getRowHeight(n) != n3) {
                jTable.setRowHeight(n, n3);
            }
        }
        if (n2 == 0) {
            return this.getResourceComponent((RDFResource)object, bl, bl2);
        }
        if (n2 == 1) {
            if (object instanceof RDFResource) {
                return this.getResourceComponent((RDFResource)object, bl, bl2);
            }
            this.textArea.setText(object != null ? object.toString() : "");
            this.plainTextPropertyValHolder.setColors(bl, bl2);
            return this.plainTextPropertyValHolder;
        }
        this.langLabel.setText(object != null ? object.toString() : "");
        this.langHolder.setColors(bl, bl2);
        return this.langHolder;
    }

    private JComponent getResourceComponent(RDFResource rDFResource, boolean bl, boolean bl2) {
        this.label.setText(rDFResource.getBrowserText());
        this.label.setIcon(ProtegeUI.getIcon(rDFResource));
        this.resourceHolder.setColors(bl, bl2);
        return this.resourceHolder;
    }

    private int getRowHeight(JTable jTable, int n) {
        Object object = jTable.getValueAt(n, 1);
        if (object instanceof String) {
            String string = object.toString();
            this.textArea.setText(string);
            View view = this.textArea.getUI().getRootView(this.textArea);
            view.setSize(jTable.getColumnModel().getColumn(1).getWidth(), 2.1474836E9f);
            int n2 = (int)view.getPreferredSpan(1) + 4;
            if (n2 < jTable.getRowHeight()) {
                n2 = jTable.getRowHeight();
            }
            return n2;
        }
        return jTable.getRowHeight();
    }
}

