/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextFormatter;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditor;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorHandler;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SyntaxConverter;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceIgnoreCaseComparator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;

public abstract class SymbolTextField
extends JTextField
implements KeyListener,
SymbolEditor {
    private SymbolEditorHandler editorHandler;
    private JComboBox comboBox;
    private SymbolErrorDisplay errorDisplay;
    private ResourceNameMatcher resourceNameMatcher;
    private OWLModel owlModel;
    private KeyEvent previousKeyPressed;
    public static final int SCALABLE_FRAME_COUNT = 1000;
    private SyntaxConverter syntaxConverter;
    private boolean inSaveTestMode = false;

    public SymbolTextField(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay, ResourceNameMatcher resourceNameMatcher, SyntaxConverter syntaxConverter) {
        this.resourceNameMatcher = resourceNameMatcher;
        this.owlModel = oWLModel;
        this.syntaxConverter = syntaxConverter;
        this.errorDisplay = symbolErrorDisplay;
        this.setBackground(Color.white);
        this.removeAll();
        this.addKeyListener(this);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                if (SymbolTextField.this.previousKeyPressed != null) {
                    int n = SymbolTextField.this.previousKeyPressed.getKeyCode();
                    if (!SymbolTextField.isIdChar(SymbolTextField.this.previousKeyPressed.getKeyChar()) && n != 8 && n != 127) {
                        SymbolTextField.this.closeComboBox();
                    }
                }
            }
        });
    }

    private void acceptSelectedResource() {
        int n;
        String string = this.getText();
        int n2 = this.getCaretPosition();
        for (n = n2 - 1; n >= 0 && SymbolTextField.isIdChar(string.charAt(n)); --n) {
        }
        String string2 = string.substring(n + 1, n2);
        RDFResource rDFResource = (RDFResource)this.comboBox.getSelectedItem();
        this.extendPartialName(string2, this.resourceNameMatcher.getInsertString(rDFResource));
        this.updateErrorDisplay();
        this.closeComboBox();
    }

    public void assignExpression() {
        this.handleEnter();
    }

    public void backspace() {
        String string = this.getSelectedText();
        if (string != null && string.length() > 0) {
            int n = this.getSelectionStart();
            try {
                this.getDocument().remove(n, this.getSelectionEnd() - n);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
            this.setCaretPosition(n);
        } else {
            int n = this.getCaretPosition();
            if (n > 0) {
                try {
                    this.getDocument().remove(n - 1, 1);
                }
                catch (BadLocationException badLocationException) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
                }
                this.setCaretPosition(n - 1);
            }
        }
        this.updateErrorDisplay();
        this.requestFocus();
    }

    public void cancelEditing() {
        this.handleEscape();
    }

    protected abstract void checkUniCodeExpression(String var1) throws Throwable;

    protected boolean isInSaveTestMode() {
        return this.inSaveTestMode;
    }

    private void closeComboBox() {
        this.removeAll();
    }

    public void displayError() {
        try {
            String string = this.getText();
            this.checkUniCodeExpression(string);
            this.errorDisplay.displayError((Throwable)null);
        }
        catch (Throwable throwable) {
            this.errorDisplay.displayError(throwable);
        }
        this.requestFocus();
    }

    private void extendPartialName(String string, String string2) {
        try {
            this.getDocument().remove(this.getCaretPosition() - string.length(), string.length());
            this.getDocument().insertString(this.getCaretPosition(), string2, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void extendPartialName(boolean bl) {
        int n;
        String string = this.getText();
        int n2 = this.getCaretPosition();
        for (n = n2 - 1; n >= 0 && SymbolTextField.isIdChar(string.charAt(n)); --n) {
        }
        String string2 = string.substring(n + 1, n2);
        String string3 = string.substring(0, n + 1);
        List list = this.resourceNameMatcher.getMatchingResources(string2, string3, this.owlModel);
        if (bl && list.size() == 1) {
            RDFResource rDFResource = (RDFResource)list.get(0);
            this.extendPartialName(string2, this.resourceNameMatcher.getInsertString(rDFResource));
            this.closeComboBox();
        } else if (list.size() > 1) {
            this.showComboBox(list, n + 1);
        }
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    private int getXOfPosition(int n) {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return fontMetrics.stringWidth(this.getText().substring(0, n));
    }

    private void handleDown() {
        int n;
        if (this.comboBox != null && this.comboBox.isVisible() && (n = this.comboBox.getSelectedIndex()) < this.comboBox.getItemCount() - 1) {
            this.comboBox.setSelectedIndex(n + 1);
        }
    }

    protected void handleEnter() {
        if (this.isComboBoxVisible()) {
            this.acceptSelectedResource();
        } else {
            this.inSaveTestMode = true;
            try {
                String string = this.getText();
                this.checkUniCodeExpression(string);
                this.stopEditing();
            }
            catch (Throwable throwable) {
                this.errorDisplay.displayError(throwable);
                this.requestFocus();
            }
            this.inSaveTestMode = false;
        }
    }

    private void handleEscape() {
        if (this.isComboBoxVisible()) {
            this.closeComboBox();
        } else {
            this.editorHandler.cancelEditing();
        }
    }

    private void handleUp() {
        int n;
        if (this.isComboBoxVisible() && (n = this.comboBox.getSelectedIndex()) > 0) {
            this.comboBox.setSelectedIndex(n - 1);
        }
    }

    public void insertText(String string) {
        this.insertText(string, string.length());
    }

    public void insertText(String string, int n) {
        String string2 = this.getSelectedText();
        if (string2 != null && string2.length() > 0) {
            int n2 = this.getSelectionStart();
            try {
                this.getDocument().remove(n2, this.getSelectionEnd() - n2);
                this.getDocument().insertString(n2, string, null);
                this.setCaretPosition(n2 + n);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
        } else {
            try {
                int n3 = this.getCaretPosition();
                this.getDocument().insertString(n3, string, null);
                this.setCaretPosition(n3 + n);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
        }
        this.updateErrorDisplay();
        this.requestFocus();
    }

    private boolean isComboBoxVisible() {
        return this.comboBox != null && this.comboBox.isVisible() && this.comboBox.isShowing();
    }

    public static boolean isIdChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == ':' || c == '-';
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.updateErrorDisplay();
        this.previousKeyPressed = keyEvent;
        int n = keyEvent.getKeyCode();
        if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == ' ' && (keyEvent.getModifiers() & 2) != 0) {
            this.extendPartialName(true);
            keyEvent.consume();
        } else {
            switch (n) {
                case 40: {
                    this.handleDown();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    this.handleUp();
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    this.handleEscape();
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    this.handleEnter();
                    keyEvent.consume();
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.perhapsConvertSyntax(keyEvent);
        this.updateErrorDisplay();
        int n = keyEvent.getKeyCode();
        if (n != 40 && n != 38) {
            this.refreshComboBox();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.perhapsConvertSyntax(keyEvent);
    }

    private void perhapsConvertSyntax(KeyEvent keyEvent) {
        if (this.syntaxConverter != null) {
            char c = keyEvent.getKeyChar();
            int n = keyEvent.getKeyCode();
            if (!SymbolTextField.isIdChar(c) && n != 8 && n != 127) {
                this.syntaxConverter.convertSyntax(this);
            }
        }
    }

    private void refreshComboBox() {
        if (this.isComboBoxVisible()) {
            String string;
            int n;
            String string2 = this.getText();
            int n2 = this.getCaretPosition();
            for (n = n2 - 1; n >= 0 && SymbolTextField.isIdChar(string2.charAt(n)); --n) {
            }
            String string3 = string2.substring(n + 1, n2);
            List list = this.resourceNameMatcher.getMatchingResources(string3, string = string2.substring(0, n + 1), this.owlModel);
            if (list.size() == 0) {
                this.closeComboBox();
            } else {
                this.showComboBox(list, n + 1);
            }
        }
    }

    void replaceText(String string) {
        this.setText(string);
        this.updateErrorDisplay();
        this.requestFocus();
    }

    public void setSymbolEditorHandler(SymbolEditorHandler symbolEditorHandler) {
        this.editorHandler = symbolEditorHandler;
    }

    private void showComboBox(List list, int n) {
        this.closeComboBox();
        Frame[] frameArray = list.toArray(new Frame[0]);
        Arrays.sort(frameArray, new ResourceIgnoreCaseComparator());
        this.comboBox = new JComboBox<Frame>(frameArray);
        this.comboBox.setBackground(Color.white);
        this.comboBox.setRenderer(new FrameRenderer());
        this.comboBox.setSize(this.comboBox.getPreferredSize().width + 20, 0);
        int n2 = this.getXOfPosition(n) - 16;
        this.comboBox.setLocation(n2, this.getHeight());
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((long)actionEvent.getModifiers() & 0x10L) != 0L) {
                    SymbolTextField.this.acceptSelectedResource();
                }
            }
        });
        this.add(this.comboBox);
        this.comboBox.showPopup();
    }

    protected void stopEditing() {
        if (this.editorHandler != null) {
            this.editorHandler.stopEditing();
        }
    }

    private void updateErrorDisplay() {
        String string = this.getText();
        try {
            this.checkUniCodeExpression(string);
            this.errorDisplay.displayError((Throwable)null);
            this.setBackground(Color.white);
        }
        catch (Throwable throwable) {
            this.errorDisplay.setErrorFlag(true);
            this.setBackground(new Color(240, 240, 240));
        }
    }

    protected void updateSyntax() {
        OWLTextFormatter.updateSyntax(this, this.owlModel);
    }
}

