/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.code.ComponentDragger;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditor;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public abstract class SymbolPanel
extends JPanel
implements SymbolErrorDisplay {
    private Action backspaceAction;
    protected ResourceSelectionAction classAction;
    private JLabel errorLabel;
    protected ResourceSelectionAction individiualAction;
    private JButton nerdButton;
    private OWLModel owlModel;
    protected ResourceSelectionAction propertyAction;
    private SymbolEditor symbolEditor;

    public SymbolPanel(OWLModel oWLModel, boolean bl) {
        this(oWLModel, bl, false);
    }

    public SymbolPanel(OWLModel oWLModel, boolean bl, boolean bl2) {
        this(oWLModel, bl, bl2, true);
    }

    public SymbolPanel(OWLModel oWLModel, final boolean bl, boolean bl2, boolean bl3) {
        this.owlModel = oWLModel;
        this.setBackground(new Color(230, 230, 230));
        this.classAction = new InsertClassAction();
        this.propertyAction = new InsertPropertyAction();
        this.individiualAction = new InsertIndividualAction();
        this.errorLabel = new JLabel(" ");
        this.errorLabel.setFont(this.getFont().deriveFont(0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add("Center", this.errorLabel);
        JToolBar jToolBar = ComponentFactory.createToolBar();
        JToolBar jToolBar2 = bl3 ? ComponentFactory.createToolBar() : null;
        JToolBar jToolBar3 = bl3 ? jToolBar2 : jToolBar;
        this.initTopBar(jToolBar);
        if (bl3) {
            this.initMiddleBar(jToolBar2);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(jToolBar);
        this.add(Box.createVerticalStrut(4));
        if (bl3) {
            this.add(jToolBar2);
            this.add(Box.createVerticalStrut(4));
        }
        this.add(jPanel);
        this.backspaceAction = new AbstractAction("Backspace", OWLIcons.getBackspaceIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                SymbolPanel.this.symbolEditor.backspace();
            }
        };
        this.addButton(jToolBar3, this.backspaceAction);
        jToolBar3.addSeparator();
        jToolBar.addSeparator(new Dimension(20, 0));
        this.nerdButton = ComponentFactory.addToolBarButton((JToolBar)jToolBar, (Action)new AbstractAction("Ok", OWLIcons.getNerdSmilingIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                if (bl) {
                    SymbolPanel.this.symbolEditor.assignExpression();
                } else {
                    SymbolPanel.this.symbolEditor.displayError();
                }
            }
        });
        this.setErrorFlag(false);
        if (bl) {
            this.addButton(jToolBar, new AbstractAction("Cancel editing", OWLIcons.getCloseIcon()){

                public void actionPerformed(ActionEvent actionEvent) {
                    SymbolPanel.this.symbolEditor.cancelEditing();
                }
            });
        }
        if (jToolBar2 != null) {
            jToolBar2.add(Box.createHorizontalGlue());
        }
        jToolBar.add(Box.createHorizontalGlue());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.setSize(this.getPreferredSize());
        if (bl2) {
            ComponentDragger componentDragger = new ComponentDragger(this);
            this.addMouseListener(componentDragger);
            this.addMouseMotionListener(componentDragger);
        }
    }

    protected Action addAction(String string, String string2, String string3, JToolBar jToolBar) {
        return this.addAction(string, string3, OWLIcons.getImageIcon(string2), jToolBar);
    }

    private Action addAction(String string, final String string2, Icon icon, JToolBar jToolBar) {
        String string3 = "Insert " + string;
        if (!string.equals(string2)) {
            string3 = string3 + " (" + string2 + ")";
        }
        AbstractAction abstractAction = new AbstractAction(string3, icon){

            public void actionPerformed(ActionEvent actionEvent) {
                SymbolPanel.this.symbolEditor.insertText(string2);
            }
        };
        JButton jButton = jToolBar.add(abstractAction);
        jButton.setToolTipText(string3);
        return abstractAction;
    }

    protected JButton addButton(JToolBar jToolBar, Action action) {
        JButton jButton = jToolBar.add(action);
        String string = (String)action.getValue("Name");
        jButton.setToolTipText(string);
        return jButton;
    }

    public void displayError(Throwable throwable) {
        if (throwable == null) {
            this.setErrorFlag(false);
            this.errorLabel.setText(" ");
        } else {
            this.setErrorFlag(true);
            String string = this.getDisplayErrorMessage(throwable);
            this.errorLabel.setText("Error: " + string);
        }
    }

    protected abstract String getDisplayErrorMessage(Throwable var1);

    public void displayError(String string) {
        this.setErrorFlag(true);
        this.errorLabel.setText("Error: " + string);
    }

    public void enableActions(boolean bl, boolean bl2) {
        this.classAction.setEnabled(bl);
        this.propertyAction.setEnabled(bl);
        this.individiualAction.setEnabled(bl2 || bl);
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    protected SymbolEditor getSymbolEditor() {
        return this.symbolEditor;
    }

    protected void initMiddleBar(JToolBar jToolBar) {
    }

    protected abstract void initTopBar(JToolBar var1);

    protected void insertCls(Cls cls) {
        String string = cls.getName();
        this.symbolEditor.insertText(string + " ");
    }

    protected void insertIndividual(RDFResource rDFResource) {
        String string = rDFResource.getName();
        if (string.startsWith("xsd:")) {
            string = rDFResource.getLocalName();
        }
        this.symbolEditor.insertText(string + " ");
    }

    protected void insertSlot(Slot slot) {
        String string = slot.getName();
        this.symbolEditor.insertText(string + " ");
    }

    public void setSymbolEditor(SymbolEditor symbolEditor) {
        this.symbolEditor = symbolEditor;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.enableActions(bl, bl);
        this.nerdButton.setEnabled(bl);
        this.backspaceAction.setEnabled(bl);
    }

    public void setErrorFlag(boolean bl) {
        this.nerdButton.setIcon(bl ? OWLIcons.getNerdErrorIcon() : OWLIcons.getNerdSmilingIcon());
        this.nerdButton.setToolTipText(bl ? "Show error message" : "Assign (Ok)");
    }

    private class InsertPropertyAction
    extends ResourceSelectionAction {
        InsertPropertyAction() {
            super("Insert property...", OWLIcons.getImageIcon("RDFProperty"));
        }

        public void resourceSelected(RDFResource rDFResource) {
            SymbolPanel.this.insertSlot((Slot)rDFResource);
        }

        public Collection getSelectableResources() {
            ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
            for (RDFProperty rDFProperty : SymbolPanel.this.owlModel.getVisibleUserDefinedRDFProperties()) {
                if (rDFProperty.isAnnotationProperty()) continue;
                arrayList.add(rDFProperty);
            }
            return arrayList;
        }

        public RDFResource pickResource() {
            Collection collection = this.getSelectableResources();
            return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(SymbolPanel.this, SymbolPanel.this.owlModel, collection, "Select the property to insert");
        }
    }

    private class InsertIndividualAction
    extends ResourceSelectionAction {
        InsertIndividualAction() {
            super("Insert individual...", OWLIcons.getImageIcon("RDFIndividual"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Set set = ProtegeUI.getSelectionDialogFactory().selectResourcesByType(SymbolPanel.this, SymbolPanel.this.owlModel, Collections.singleton(SymbolPanel.this.owlModel.getOWLThingClass()), "Select the resources to insert");
            for (Frame frame : set) {
                if (!(frame instanceof RDFResource)) continue;
                this.resourceSelected((RDFResource)frame);
            }
        }

        public void resourceSelected(RDFResource rDFResource) {
            SymbolPanel.this.insertIndividual(rDFResource);
        }

        public Collection getSelectableResources() {
            Collection collection = SymbolPanel.this.owlModel.getOWLIndividuals();
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new FrameComparator());
            return arrayList;
        }

        public RDFResource pickResource() {
            Collection collection = this.getSelectableResources();
            return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(SymbolPanel.this, SymbolPanel.this.owlModel, collection, "Select the resource to insert");
        }
    }

    private class InsertClassAction
    extends ResourceSelectionAction {
        InsertClassAction() {
            super("Insert class...", OWLIcons.getImageIcon("PrimitiveClass"));
        }

        public void resourceSelected(RDFResource rDFResource) {
            SymbolPanel.this.insertCls((Cls)rDFResource);
        }

        public Collection getSelectableResources() {
            return OWLUtil.getSelectableNamedClses(SymbolPanel.this.owlModel);
        }

        public RDFResource pickResource() {
            return ProtegeUI.getSelectionDialogFactory().selectClass(SymbolPanel.this, SymbolPanel.this.owlModel);
        }
    }
}

