/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OWLResourceNameMatcher
implements ResourceNameMatcher {
    public static final int SCALABLE_FRAME_COUNT = 1000;

    public String getInsertString(RDFResource rDFResource) {
        return rDFResource.getBrowserText();
    }

    public List getMatchingResources(String string, String string2, OWLModel oWLModel) {
        if (oWLModel instanceof OWLDatabaseModel && string.length() < 3) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        OWLClassParseException oWLClassParseException = OWLClassParseException.getRecentInstance();
        if (oWLClassParseException.nextCouldBeClass || oWLModel.getRDFResource(string) instanceof RDFSNamedClass) {
            OWLResourceNameMatcher.getMatchingRDFSNamedClasses(string, arrayList, oWLModel);
        }
        if (oWLClassParseException.nextCouldBeIndividual || oWLModel.getRDFResource(string) != null) {
            OWLResourceNameMatcher.getMatchingRDFIndividuals(string, arrayList, oWLModel);
        }
        if (oWLClassParseException.nextCouldBeProperty || oWLModel.getRDFResource(string) instanceof RDFProperty) {
            OWLResourceNameMatcher.getMatchingRDFProperties(string, arrayList, oWLModel);
        }
        if (oWLClassParseException.nextCouldBeDatatypeName || oWLModel.getRDFResource(string) instanceof RDFSDatatype) {
            OWLResourceNameMatcher.getMatchingDatatypeNames(string, arrayList, oWLModel);
        }
        return arrayList;
    }

    public static void getMatchingRDFSNamedClasses(String string, List list, OWLModel oWLModel) {
        block3: {
            block2: {
                if (string.length() != 0) break block2;
                int n = oWLModel.getRDFSClassCount();
                if (n >= 1000) break block3;
                for (RDFSNamedClass rDFSNamedClass : OWLUtil.getSelectableNamedClses(oWLModel)) {
                    if (!rDFSNamedClass.isVisibleFromOWLThing()) continue;
                    list.add(rDFSNamedClass);
                }
                break block3;
            }
            Collection collection = oWLModel.getResourceNameMatches(string + "*", 1000);
            for (Frame frame : collection) {
                if (!(frame instanceof RDFSNamedClass) || !frame.isVisible() || !OWLResourceNameMatcher.isSlowProject(oWLModel) && !((RDFSNamedClass)frame).isVisibleFromOWLThing()) continue;
                list.add(frame);
            }
        }
    }

    private static boolean isSlowProject(OWLModel oWLModel) {
        return oWLModel.getProject().isMultiUserClient();
    }

    public static void getMatchingRDFProperties(String string, List list, OWLModel oWLModel) {
        Collection collection = oWLModel.getResourceNameMatches(string + "*", 1000);
        for (Frame frame : collection) {
            if (!(frame instanceof RDFProperty) || !frame.isVisible()) continue;
            list.add(frame);
        }
    }

    public static void getMatchingRDFIndividuals(String string, List list, OWLModel oWLModel) {
        Collection collection = oWLModel.getResourceNameMatches(string + "*", 1000);
        for (Frame frame : collection) {
            if (!(frame instanceof RDFIndividual) || !frame.isVisible()) continue;
            list.add(frame);
        }
    }

    public static void getMatchingDatatypeNames(String string, List list, OWLModel oWLModel) {
        Collection collection = oWLModel.getRDFSDatatypes();
        for (RDFSDatatype rDFSDatatype : collection) {
            if (rDFSDatatype.isAnonymous() || !rDFSDatatype.getBrowserText().startsWith(string)) continue;
            list.add(rDFSDatatype);
        }
    }
}

