/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RDFPropertiesTableColumns;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RDFPropertiesTableModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RDFPropertiesTable
extends JTable
implements Disposable,
RDFPropertiesTableColumns {
    private RDFSNamedClass cls;
    private RDFPropertiesTableModel tableModel = new RDFPropertiesTableModel();

    public RDFPropertiesTable() {
        this.setModel(this.tableModel);
        this.setColumnWidth(0, 150);
        this.setColumnWidth(1, 100);
        this.setColumnWidth(2, 150);
        this.setDefaultRenderer(RDFResource.class, (TableCellRenderer)((Object)new ResourceRenderer(){
            private int nextRow;

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.nextRow = n;
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }

            protected void loadSlot(Slot slot) {
                super.loadSlot(slot);
                RDFProperty rDFProperty = (RDFProperty)slot;
                if (!RDFPropertiesTable.this.tableModel.isDirectProperty(this.nextRow)) {
                    this.setMainIcon(rDFProperty.getInheritedIcon());
                }
            }
        }));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    RDFPropertiesTable.this.handleDoubleClick();
                }
            }
        });
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    public RDFPropertiesTableModel getTableModel() {
        return this.tableModel;
    }

    public void handleAddProperty(RDFProperty rDFProperty) {
        rDFProperty.addUnionDomainClass(this.cls);
        this.setSelectedProperty(rDFProperty);
    }

    protected void handleDoubleClick() {
        int[] nArray = this.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            RDFProperty rDFProperty = this.tableModel.getRDFProperty(n);
            rDFProperty.getProject().show((Instance)rDFProperty);
        }
    }

    public void handlePropertyCreated(RDFProperty rDFProperty) {
        rDFProperty.setDomain(this.cls);
        this.setSelectedProperty(rDFProperty);
    }

    private void setSelectedProperty(RDFProperty rDFProperty) {
        int n = this.tableModel.getRow(rDFProperty);
        if (n >= 0) {
            this.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    public void handleRemoveProperties() {
        int[] nArray = this.getSelectedRows();
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            arrayList.add(this.tableModel.getRDFProperty(n));
        }
        for (RDFProperty rDFProperty : arrayList) {
            rDFProperty.removeUnionDomainClass(this.cls);
        }
    }

    private void setColumnWidth(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
    }

    public void setClass(RDFSNamedClass rDFSNamedClass) {
        this.cls = rDFSNamedClass;
        this.tableModel.setClass(rDFSNamedClass);
    }
}

