/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.clsproperties.CreatePropertyAction;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RDFPropertiesTable;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RDFPropertiesComponent
extends JPanel {
    private Action addPropertyAction = new ResourceSelectionAction("Add property...", OWLIcons.getAddIcon("RDFProperty")){

        public Collection getSelectableResources() {
            ArrayList arrayList = new ArrayList(RDFPropertiesComponent.this.cls.getOWLModel().getUserDefinedRDFProperties());
            arrayList.removeAll(RDFPropertiesComponent.this.cls.getUnionDomainProperties());
            return arrayList;
        }

        public RDFResource pickResource() {
            return ProtegeUI.getSelectionDialogFactory().selectProperty(RDFPropertiesComponent.this, RDFPropertiesComponent.this.cls.getOWLModel(), this.getSelectableResources(), "Select a property to add");
        }

        public void resourceSelected(RDFResource rDFResource) {
            RDFPropertiesComponent.this.table.handleAddProperty((RDFProperty)rDFResource);
        }
    };
    private RDFSNamedClass cls;
    private Action removePropertiesAction = new AbstractAction("Remove selected properties", OWLIcons.getRemoveIcon("RDFProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            RDFPropertiesComponent.this.table.handleRemoveProperties();
        }
    };
    private RDFPropertiesTable table = new RDFPropertiesTable();

    public RDFPropertiesComponent(OWLModel oWLModel) {
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(Color.white);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Properties", jScrollPane);
        CreatePropertyAction.addActions(oWLLabeledComponent, oWLModel, new CreatePropertyAction.CallBack(){

            public void propertyCreated(RDFProperty rDFProperty) {
                RDFPropertiesComponent.this.table.handlePropertyCreated(rDFProperty);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RDFPropertiesComponent.this.updateActions();
            }
        });
        oWLLabeledComponent.addHeaderButton(this.addPropertyAction);
        oWLLabeledComponent.addHeaderButton(this.removePropertiesAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
        this.updateActions();
    }

    public void setClass(RDFSNamedClass rDFSNamedClass) {
        this.cls = rDFSNamedClass;
        this.table.setClass(rDFSNamedClass);
    }

    private void updateActions() {
        boolean bl = false;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length > 0) {
            bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (this.table.getTableModel().isDirectProperty(n)) continue;
                bl = false;
                break;
            }
        }
        this.removePropertiesAction.setEnabled(bl);
    }
}

