/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;

public class PropertyRestrictionsTreeRenderer
extends ResourceRenderer {
    private boolean displayRestrictions;
    private boolean expanded;
    private boolean hideGlobalCharacteristics = true;
    private Cls originCls;

    public PropertyRestrictionsTreeRenderer(boolean bl, boolean bl2) {
        this.displayRestrictions = bl;
        this.hideGlobalCharacteristics = bl2;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.expanded = bl2;
        return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    public void load(Object object) {
        if (object instanceof RestrictionTreeNode) {
            Object object2;
            RestrictionTreeNode restrictionTreeNode = (RestrictionTreeNode)object;
            Icon icon = restrictionTreeNode.getIcon();
            this.clear();
            this.setMainIcon(icon);
            this.setMainText(restrictionTreeNode.getFillerText());
            this.originCls = restrictionTreeNode.getInheritedFromClass();
            Object object3 = restrictionTreeNode.getUserObject();
            if (object3 instanceof OWLQuantifierRestriction) {
                RDFResource rDFResource = ((OWLQuantifierRestriction)object3).getFiller();
                if (rDFResource instanceof OWLClass) {
                    this.loadedClass = (OWLClass)rDFResource;
                }
            } else if (object3 instanceof OWLCardinalityBase) {
                RDFSClass rDFSClass = ((OWLCardinalityBase)object3).getQualifier();
                if (rDFSClass instanceof OWLClass) {
                    this.loadedClass = (OWLClass)rDFSClass;
                }
            } else if (object3 instanceof OWLHasValue && (object2 = ((OWLHasValue)object3).getHasValue()) instanceof OWLClass) {
                this.loadedClass = (OWLClass)object2;
            }
        } else if (object instanceof PropertyTreeNode) {
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)object;
            RDFProperty rDFProperty = propertyTreeNode.getRDFProperty();
            Icon icon = propertyTreeNode.getIcon();
            this.setMainIcon(icon);
            String string = rDFProperty.getBrowserText();
            this.setMainText(string);
            this.originCls = null;
            if (!this.hideGlobalCharacteristics) {
                boolean bl;
                RDFSNamedClass rDFSNamedClass = rDFProperty.getOWLModel().getRDFSNamedClass("owl:AllValuesFromRestriction");
                boolean bl2 = bl = this.displayRestrictions && propertyTreeNode.hasRestrictionOfType(rDFSNamedClass);
                if (!bl) {
                    String string2;
                    RDFResource rDFResource = rDFProperty.getRange(true);
                    String string3 = string2 = rDFProperty.isFunctional() ? "single" : "multiple";
                    if (rDFResource != null) {
                        this.addText("    (" + string2 + " " + rDFResource.getBrowserText() + ")");
                    } else if (rDFProperty.isFunctional()) {
                        this.addText("    (" + string2 + ")");
                    }
                }
            }
            if (this.displayRestrictions && propertyTreeNode.getChildCount() > 0) {
                this.addText("     (");
                for (int i = 0; i < propertyTreeNode.getChildCount(); ++i) {
                    RestrictionTreeNode restrictionTreeNode = (RestrictionTreeNode)propertyTreeNode.getChildAt(i);
                    this.addText(restrictionTreeNode.getOperatorName() + " ");
                    this.addText(restrictionTreeNode.getFillerText());
                    if (i >= propertyTreeNode.getChildCount() - 1) continue;
                    this.addText(",  ");
                }
                this.addText(")");
            }
        } else {
            super.load(object);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getWidth();
        FontMetrics fontMetrics = this._fontMetrics;
        int n2 = fontMetrics.stringWidth(this.getMainText());
        int n3 = fontMetrics.getAscent();
        if (this.originCls != null) {
            String string = this.originCls.getBrowserText();
            String string2 = "[from " + string + "]";
            int n4 = fontMetrics.stringWidth(string2);
            int n5 = string.length();
            int n6 = n - 3;
            while (n5 > 3 && n6 - n4 - 2 <= n2 + 4) {
                string2 = "[from " + string.substring(0, --n5) + "...]";
                n4 = fontMetrics.stringWidth(string2);
            }
            if (n6 - n4 - 2 > n2 + 4) {
                graphics.setColor(Color.gray);
                graphics.drawString(string2, n6 - n4 - 2, n3);
            }
        }
    }
}

