/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTree;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.restrictions.RestrictionKindRenderer;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.Collections;
import javax.swing.Icon;

public class NewRestrictionTreeNode
extends RestrictionTreeNode {
    private Cls metaCls;
    private PropertyRestrictionsTree tree;

    public NewRestrictionTreeNode(Cls cls, PropertyRestrictionsTree propertyRestrictionsTree) {
        this.metaCls = cls;
        this.tree = propertyRestrictionsTree;
    }

    public void checkExpression(String string) throws Throwable {
        RDFProperty rDFProperty = this.getParentNode().getRDFProperty();
        String string2 = this.metaCls.getName();
        if (string2.equals("owl:HasValueRestriction")) {
            DefaultOWLHasValue.checkFillerText(string, rDFProperty);
        } else if (string2.equals("owl:AllValuesFromRestriction") || string2.equals("owl:SomeValuesFromRestriction")) {
            AbstractOWLQuantifierRestriction.checkFillerText(string, rDFProperty);
        } else {
            AbstractOWLCardinalityBase.checkFillerText(string, rDFProperty);
        }
    }

    public String getFillerText() {
        return "";
    }

    public Icon getIcon() {
        return RestrictionKindRenderer.getClsIcon(this.metaCls);
    }

    public char getOperator() {
        String string = this.metaCls.getName();
        if ("owl:AllValuesFromRestriction".equals(string)) {
            return '\u2200';
        }
        if ("owl:HasValueRestriction".equals(string)) {
            return '\u220b';
        }
        if ("owl:SomeValuesFromRestriction".equals(string)) {
            return '\u2203';
        }
        if ("owl:CardinalityRestriction".equals(string)) {
            return '=';
        }
        if ("owl:MaxCardinalityRestriction".equals(string)) {
            return '\u2264';
        }
        if ("owl:MinCardinalityRestriction".equals(string)) {
            return '\u2265';
        }
        return '?';
    }

    public Cls getRestrictionMetaCls() {
        return this.metaCls;
    }

    public RDFSClass getInheritedFromClass() {
        return null;
    }

    public boolean isInherited() {
        return false;
    }

    public void setUserObject(Object object) {
        KnowledgeBase knowledgeBase = this.metaCls.getKnowledgeBase();
        OWLModel oWLModel = (OWLModel)knowledgeBase;
        try {
            OWLNamedClass oWLNamedClass = this.getParentNode().getRestrictedClass();
            oWLModel.beginTransaction("Add restriction on property " + this.getParentNode().getRDFProperty().getBrowserText() + " at class " + oWLNamedClass.getBrowserText());
            Cls cls = oWLModel.getCls(":OWL-ANONYMOUS-ROOT");
            OWLRestriction oWLRestriction = (OWLRestriction)knowledgeBase.createCls(null, Collections.singleton(cls), this.metaCls);
            oWLRestriction.setOnProperty(this.getParentNode().getRDFProperty());
            String string = (String)object;
            oWLRestriction.setFillerText(string);
            RDFSClass rDFSClass = oWLNamedClass.getDefinition();
            if (rDFSClass != null) {
                if (rDFSClass instanceof OWLIntersectionClass) {
                    ((OWLIntersectionClass)rDFSClass).addOperand(oWLRestriction);
                    oWLModel.endTransaction();
                    this.tree.refill();
                } else {
                    OWLIntersectionClass oWLIntersectionClass = oWLModel.createOWLIntersectionClass();
                    oWLIntersectionClass.addOperand(rDFSClass.createClone());
                    oWLIntersectionClass.addOperand(oWLRestriction);
                    oWLNamedClass.setDefinition(oWLIntersectionClass);
                    oWLModel.endTransaction();
                }
            } else {
                oWLNamedClass.addSuperclass(oWLRestriction);
                oWLModel.endTransaction();
            }
            this.tree.setSelectedRestriction(oWLRestriction);
        }
        catch (Exception exception) {
            OWLUI.handleError(oWLModel, exception);
            oWLModel.endTransaction();
        }
    }
}

