/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc.manchester;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.classparser.manchester.ManchesterOWLParserUtil;
import edu.stanford.smi.protegex.owl.ui.clsdesc.manchester.SuggestionPopup;
import edu.stanford.smi.protegex.owl.ui.code.OWLResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextFormatter;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorHandler;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SyntaxConverter;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceIgnoreCaseComparator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public class ManchesterOWLTextPane
extends JTextPane
implements KeyListener {
    private JComboBox comboBox;
    private SymbolErrorDisplay errorDisplay;
    private ResourceNameMatcher resourceNameMatcher;
    private OWLModel model;
    private KeyEvent previousKeyPressed;
    public static final int SCALABLE_FRAME_COUNT = 1000;
    private SyntaxConverter syntaxConverter;
    private boolean inSaveTestMode = false;
    private SymbolEditorHandler editorHandler;
    private DocumentListener docListener;
    private Map styleMap;
    private Style defaultStyle;
    private static final Color RESTRICTION_KEYWORD_COLOR = Color.MAGENTA.darker();
    private static final Color LOGICAL_OPERAND_KEYWORD_COLOR = Color.CYAN.darker();
    private static Font font = new JList().getFont();
    private CaretListener caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent caretEvent) {
            ManchesterOWLTextPane.this.performMatching();
        }
    };
    private FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            ManchesterOWLTextPane.this.cleanupPrevious();
        }
    };
    private Highlighter.HighlightPainter matchedHighlightPainter;
    private Highlighter.HighlightPainter unmatchedHighlightPainter;
    private Object h0;
    private Object h1;

    public ManchesterOWLTextPane(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay, ResourceNameMatcher resourceNameMatcher, SyntaxConverter syntaxConverter) {
        this.model = oWLModel;
        this.errorDisplay = symbolErrorDisplay;
        this.resourceNameMatcher = resourceNameMatcher;
        this.syntaxConverter = syntaxConverter;
        this.resourceNameMatcher = new OWLResourceNameMatcher();
        this.setFont(font);
        this.setBackground(Color.white);
        this.removeAll();
        this.addKeyListener(this);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                if (ManchesterOWLTextPane.this.previousKeyPressed != null) {
                    int n = ManchesterOWLTextPane.this.previousKeyPressed.getKeyCode();
                    if (!ManchesterOWLTextPane.isIdChar(ManchesterOWLTextPane.this.previousKeyPressed.getKeyChar()) && n != 8 && n != 127) {
                        ManchesterOWLTextPane.this.closeComboBox();
                    }
                }
            }
        });
        this.initColorMap();
        this.docListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ManchesterOWLTextPane.this.performHighlighting();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ManchesterOWLTextPane.this.performHighlighting();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.getDocument().addDocumentListener(this.docListener);
        this.setFocusable(true);
        this.setupBrackertMatcher();
        Window window = (Window)Application.getMainWindow();
        if (window != null) {
            SuggestionPopup suggestionPopup = new SuggestionPopup(window, this.model);
            suggestionPopup.setCurrentEditorPane(this);
        }
    }

    public int getPreferredHeight(int n) {
        View view = this.getUI().getRootView(this);
        view.setSize(n, 2.1474836E9f);
        return (int)view.getPreferredSpan(1);
    }

    private void initColorMap() {
        StyledDocument styledDocument = (StyledDocument)this.getDocument();
        Style style = styledDocument.addStyle("rs", null);
        StyleConstants.setForeground(style, RESTRICTION_KEYWORD_COLOR);
        StyleConstants.setBold(style, true);
        Style style2 = styledDocument.addStyle("lk", null);
        StyleConstants.setForeground(style2, LOGICAL_OPERAND_KEYWORD_COLOR);
        StyleConstants.setBold(style2, true);
        this.styleMap = new HashMap();
        this.styleMap.put(ManchesterOWLParserUtil.getAllKeyword(), style);
        this.styleMap.put(ManchesterOWLParserUtil.getSomeKeyword(), style);
        this.styleMap.put(ManchesterOWLParserUtil.getHasKeyword(), style);
        this.styleMap.put(ManchesterOWLParserUtil.getMinKeyword(), style);
        this.styleMap.put(ManchesterOWLParserUtil.getMaxKeyword(), style);
        this.styleMap.put(ManchesterOWLParserUtil.getExactKeyword(), style);
        this.styleMap.put(ManchesterOWLParserUtil.getAndKeyword(), style2);
        this.styleMap.put(ManchesterOWLParserUtil.getOrKeyword(), style2);
        this.styleMap.put(ManchesterOWLParserUtil.getNotKeyword(), style2);
        this.defaultStyle = styledDocument.addStyle("def", null);
    }

    public void setSymbolEditorHandler(SymbolEditorHandler symbolEditorHandler) {
        this.editorHandler = symbolEditorHandler;
    }

    private void performHighlighting() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                String string = ManchesterOWLTextPane.this.getText();
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ()[]{}", true);
                int n = 0;
                StyledDocument styledDocument = (StyledDocument)ManchesterOWLTextPane.this.getDocument();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    Style style = (Style)ManchesterOWLTextPane.this.styleMap.get(string2);
                    if (style != null) {
                        styledDocument.setCharacterAttributes(n, string2.length(), style, true);
                    } else {
                        styledDocument.setCharacterAttributes(n, string2.length(), ManchesterOWLTextPane.this.defaultStyle, true);
                    }
                    n += string2.length();
                }
            }
        });
        thread.start();
    }

    private void acceptSelectedResource() {
        int n;
        String string = this.getText();
        int n2 = this.getCaretPosition();
        for (n = n2 - 1; n >= 0 && ManchesterOWLTextPane.isIdChar(string.charAt(n)); --n) {
        }
        String string2 = string.substring(n + 1, n2);
        RDFResource rDFResource = (RDFResource)this.comboBox.getSelectedItem();
        this.extendPartialName(string2, this.resourceNameMatcher.getInsertString(rDFResource));
        this.updateErrorDisplay();
        this.closeComboBox();
    }

    protected void checkUniCodeExpression(String string) throws Throwable {
        this.model.getOWLClassDisplay().getParser().checkClass(this.model, string);
    }

    protected boolean isInSaveTestMode() {
        return this.inSaveTestMode;
    }

    private void closeComboBox() {
        this.removeAll();
    }

    private void extendPartialName(String string, String string2) {
        try {
            this.getDocument().remove(this.getCaretPosition() - string.length(), string.length());
            this.getDocument().insertString(this.getCaretPosition(), string2, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void extendPartialName(boolean bl) {
        int n;
        String string = this.getText();
        int n2 = this.getCaretPosition();
        for (n = n2 - 1; n >= 0 && ManchesterOWLTextPane.isIdChar(string.charAt(n)); --n) {
        }
        String string2 = string.substring(n + 1, n2);
        String string3 = string.substring(0, n + 1);
        List list = this.resourceNameMatcher.getMatchingResources(string2, string3, this.model);
        if (bl && list.size() == 1) {
            RDFResource rDFResource = (RDFResource)list.get(0);
            this.extendPartialName(string2, this.resourceNameMatcher.getInsertString(rDFResource));
            this.closeComboBox();
        } else if (list.size() > 1) {
            this.showComboBox(list, n + 1);
        }
    }

    protected OWLModel getmodel() {
        return this.model;
    }

    private int getXOfPosition(int n) {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return fontMetrics.stringWidth(this.getText().substring(0, n));
    }

    private void handleDown() {
        int n;
        if (this.comboBox != null && this.comboBox.isVisible() && (n = this.comboBox.getSelectedIndex()) < this.comboBox.getItemCount() - 1) {
            this.comboBox.setSelectedIndex(n + 1);
        }
    }

    protected void handleEnter() {
        if (this.isComboBoxVisible()) {
            this.acceptSelectedResource();
        } else {
            this.inSaveTestMode = true;
            try {
                String string = this.getText();
                this.checkUniCodeExpression(string);
                if (this.editorHandler != null) {
                    this.editorHandler.stopEditing();
                }
            }
            catch (Throwable throwable) {
                this.errorDisplay.displayError(throwable);
                this.requestFocus();
            }
            this.inSaveTestMode = false;
        }
    }

    private void handleEscape() {
        if (this.isComboBoxVisible()) {
            this.closeComboBox();
        } else if (this.editorHandler != null) {
            this.editorHandler.cancelEditing();
        }
    }

    private void handleUp() {
        int n;
        if (this.isComboBoxVisible() && (n = this.comboBox.getSelectedIndex()) > 0) {
            this.comboBox.setSelectedIndex(n - 1);
        }
    }

    public void insertText(String string) {
        this.insertText(string, string.length());
    }

    public void insertText(String string, int n) {
        String string2 = this.getSelectedText();
        if (string2 != null && string2.length() > 0) {
            int n2 = this.getSelectionStart();
            try {
                this.getDocument().remove(n2, this.getSelectionEnd() - n2);
                this.getDocument().insertString(n2, string, null);
                this.setCaretPosition(n2 + n);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
        } else {
            try {
                int n3 = this.getCaretPosition();
                this.getDocument().insertString(n3, string, null);
                this.setCaretPosition(n3 + n);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
        }
        this.updateErrorDisplay();
        this.requestFocus();
    }

    private boolean isComboBoxVisible() {
        return this.comboBox != null && this.comboBox.isVisible() && this.comboBox.isShowing();
    }

    public static boolean isIdChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == ':' || c == '-';
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.updateErrorDisplay();
        this.previousKeyPressed = keyEvent;
        int n = keyEvent.getKeyCode();
        if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == ' ' && (keyEvent.getModifiers() & 2) != 0) {
            this.extendPartialName(true);
            keyEvent.consume();
        } else {
            switch (n) {
                case 40: {
                    if (this.comboBox == null || !this.comboBox.isVisible()) break;
                    this.handleDown();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    if (this.comboBox == null || !this.comboBox.isVisible()) break;
                    this.handleUp();
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    this.handleEscape();
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    this.handleEnter();
                    keyEvent.consume();
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.perhapsConvertSyntax(keyEvent);
        this.updateErrorDisplay();
        int n = keyEvent.getKeyCode();
        if (n != 40 && n != 38) {
            this.refreshComboBox();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.perhapsConvertSyntax(keyEvent);
    }

    private void perhapsConvertSyntax(KeyEvent keyEvent) {
        if (this.syntaxConverter != null) {
            char c = keyEvent.getKeyChar();
            int n = keyEvent.getKeyCode();
            if (!ManchesterOWLTextPane.isIdChar(c) && n != 8 && n != 127) {
                this.syntaxConverter.convertSyntax(this);
            }
        }
    }

    private void refreshComboBox() {
        if (this.isComboBoxVisible()) {
            String string;
            int n;
            String string2 = this.getText();
            int n2 = this.getCaretPosition();
            for (n = n2 - 1; n >= 0 && ManchesterOWLTextPane.isIdChar(string2.charAt(n)); --n) {
            }
            String string3 = string2.substring(n + 1, n2);
            List list = this.resourceNameMatcher.getMatchingResources(string3, string = string2.substring(0, n + 1), this.model);
            if (list.size() == 0) {
                this.closeComboBox();
            } else {
                this.showComboBox(list, n + 1);
            }
        }
    }

    void replaceText(String string) {
        this.setText(string);
        this.updateErrorDisplay();
        this.requestFocus();
    }

    private void showComboBox(List list, int n) {
        this.closeComboBox();
        Frame[] frameArray = list.toArray(new Frame[0]);
        Arrays.sort(frameArray, new ResourceIgnoreCaseComparator());
        this.comboBox = new JComboBox<Frame>(frameArray);
        this.comboBox.setBackground(Color.white);
        this.comboBox.setRenderer(new FrameRenderer());
        this.comboBox.setSize(this.comboBox.getPreferredSize().width + 20, 0);
        int n2 = this.getXOfPosition(n) - 16;
        this.comboBox.setLocation(n2, this.getHeight());
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((long)actionEvent.getModifiers() & 0x10L) != 0L) {
                    ManchesterOWLTextPane.this.acceptSelectedResource();
                }
            }
        });
        this.add(this.comboBox);
        this.comboBox.showPopup();
    }

    private void updateErrorDisplay() {
        String string = this.getText();
        try {
            this.checkUniCodeExpression(string);
            this.errorDisplay.displayError((Throwable)null);
            this.setBackground(Color.white);
        }
        catch (Throwable throwable) {
            this.errorDisplay.setErrorFlag(true);
            this.setBackground(new Color(240, 240, 240));
        }
    }

    protected void updateSyntax() {
        OWLTextFormatter.updateSyntax(this, this.model);
    }

    private void setupBrackertMatcher() {
        this.addListeners();
        this.unmatchedHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 190, 190));
        this.matchedHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(170, 170, 255));
    }

    private void addListeners() {
        this.addCaretListener(this.caretListener);
        this.addFocusListener(this.focusListener);
    }

    private void performMatching() {
        if (this.getCaret().isVisible()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ManchesterOWLTextPane.this.cleanupPrevious();
                    if (ManchesterOWLTextPane.this.isCaretBeforeOpeningBracket()) {
                        ManchesterOWLTextPane.this.doBeforeOpeningMatch();
                    }
                    if (ManchesterOWLTextPane.this.isCaretAfterClosingBracket()) {
                        ManchesterOWLTextPane.this.doAfterClosingMatch();
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    private boolean isCaretBeforeOpeningBracket() {
        int n = this.getCaretPosition();
        if (n < this.getDocument().getLength() - 1) {
            return this.getText().charAt(n) == '(';
        }
        return false;
    }

    private boolean isCaretAfterClosingBracket() {
        int n = this.getCaretPosition();
        if (n > 1) {
            return this.getText().charAt(n - 1) == ')';
        }
        return false;
    }

    private void doBeforeOpeningMatch() {
        try {
            int n = this.matchForward();
            int n2 = this.getCaretPosition();
            if (n == -1) {
                this.h0 = this.getHighlighter().addHighlight(n2, n2 + 1, this.unmatchedHighlightPainter);
                this.h1 = null;
            } else {
                this.h0 = this.getHighlighter().addHighlight(n2, n2 + 1, this.matchedHighlightPainter);
                this.h1 = this.getHighlighter().addHighlight(n, n + 1, this.matchedHighlightPainter);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
        }
    }

    private void doAfterClosingMatch() {
        try {
            int n = this.matchReverse();
            int n2 = this.getCaretPosition();
            if (n == -1) {
                this.h0 = this.getHighlighter().addHighlight(n2 - 1, n2, this.unmatchedHighlightPainter);
                this.h1 = null;
            } else {
                this.h0 = this.getHighlighter().addHighlight(n2 - 1, n2, this.matchedHighlightPainter);
                this.h1 = this.getHighlighter().addHighlight(n, n + 1, this.matchedHighlightPainter);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
        }
    }

    private int matchForward() {
        int n = -1;
        int n2 = this.getDocument().getLength();
        int n3 = 0;
        int n4 = this.getCaretPosition() + 1;
        char[] cArray = new char[n2];
        this.getText().getChars(0, n2, cArray, 0);
        for (int i = n4; i < n2; ++i) {
            if (cArray[i] == '(') {
                ++n3;
            }
            if (cArray[i] == ')' && n3 == 0) {
                n = i;
                break;
            }
            if (cArray[i] != ')') continue;
            --n3;
        }
        return n;
    }

    private int matchReverse() {
        int n = this.getCaretPosition() - 1;
        int n2 = -1;
        try {
            char[] cArray = new char[n + 1];
            this.getDocument().getText(0, n).getChars(0, n, cArray, 0);
            int n3 = 0;
            for (int i = n; i > -1; --i) {
                if (cArray[i] == ')') {
                    ++n3;
                }
                if (cArray[i] == '(' && n3 == 0) {
                    n2 = i;
                    break;
                }
                if (cArray[i] != '(') continue;
                --n3;
            }
        }
        catch (BadLocationException badLocationException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            return n2;
        }
        return n2;
    }

    private void cleanupPrevious() {
        if (this.h0 != null) {
            this.getHighlighter().removeHighlight(this.h0);
        }
        if (this.h1 != null) {
            this.getHighlighter().removeHighlight(this.h1);
        }
    }
}

