/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.clsdesc.AddRowAction;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTable;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionWidget;
import edu.stanford.smi.protegex.owl.ui.clsdesc.CreateRowAction;
import edu.stanford.smi.protegex.owl.ui.clsdesc.DisjointClassesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DisjointClassesWidget
extends ClassDescriptionWidget {
    private boolean mutuallyIsDefault = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllSiblings(boolean bl) {
        SiblingsPanel siblingsPanel = new SiblingsPanel(this.mutuallyIsDefault);
        if (bl || ProtegeUI.getModalDialogFactory().showDialog((Component)((Object)this), siblingsPanel, "Add siblings to disjoints", 11) == 1) {
            try {
                this.beginTransaction("Add siblings to disjoints of " + this.getEditedCls().getBrowserText());
                this.mutuallyIsDefault = siblingsPanel.isMutuallySelected();
                OWLNamedClass oWLNamedClass = this.getEditedCls();
                if (this.mutuallyIsDefault) {
                    for (Cls cls : oWLNamedClass.getSuperclasses(false)) {
                        if (!(cls instanceof OWLNamedClass)) continue;
                        OWLUtil.ensureSubclassesDisjoint((OWLNamedClass)cls);
                    }
                } else {
                    Set set = this.getPotentialDisjoints(oWLNamedClass);
                    Collection collection = oWLNamedClass.getDisjointClasses();
                    for (OWLNamedClass oWLNamedClass2 : set) {
                        if (oWLNamedClass2.equals(oWLNamedClass) || collection.contains(oWLNamedClass2)) continue;
                        oWLNamedClass.addDisjointClass(oWLNamedClass2);
                        oWLNamedClass2.addDisjointClass(oWLNamedClass);
                    }
                }
            }
            catch (Exception exception) {
                OWLUI.handleError(this.getOWLModel(), exception);
            }
            finally {
                this.endTransaction();
            }
        }
    }

    protected ResourceSelectionAction createAddAction(ClassDescriptionTable classDescriptionTable) {
        return new AddRowAction(this.getTable(), "Add disjoint class...", false){

            public Collection pickResources() {
                OWLNamedClass oWLNamedClass = DisjointClassesWidget.this.getEditedCls();
                oWLNamedClass.setVisible(false);
                Collection collection = super.pickResources();
                oWLNamedClass.setVisible(true);
                return collection;
            }
        };
    }

    protected Action createCreateAction(ClassDescriptionTable classDescriptionTable) {
        return new CreateRowAction(this.getTable(), "Create disjoint class from OWL expression");
    }

    protected Icon createHeaderIcon() {
        return OWLIcons.getImageIcon("OWLDisjointClasses");
    }

    protected List createCustomActions(ClassDescriptionTable classDescriptionTable) {
        AbstractAction abstractAction = new AbstractAction("Add all siblings...", OWLIcons.getAddIcon("SiblingClasses")){

            public void actionPerformed(ActionEvent actionEvent) {
                DisjointClassesWidget.this.addAllSiblings((actionEvent.getModifiers() & 2) != 0);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction("Remove all siblings...", OWLIcons.getRemoveIcon("SiblingClasses")){

            public void actionPerformed(ActionEvent actionEvent) {
                DisjointClassesWidget.this.removeAllSiblings((actionEvent.getModifiers() & 2) != 0);
            }
        };
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(abstractAction);
        arrayList.add(abstractAction2);
        return arrayList;
    }

    protected OWLTableModel createTableModel() {
        return new DisjointClassesTableModel();
    }

    protected String getLabelText() {
        return "Disjoints";
    }

    private Set getPotentialDisjoints(OWLNamedClass oWLNamedClass) {
        HashSet hashSet = new HashSet();
        for (Cls cls : oWLNamedClass.getSuperclasses(false)) {
            if (!(cls instanceof OWLNamedClass)) continue;
            hashSet.addAll(OWLUtil.getPotentiallyDisjointSubclasses((OWLNamedClass)cls));
        }
        return hashSet;
    }

    public void initialize() {
        super.initialize();
        this.getTable().getSelectionModel().setSelectionMode(2);
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer(){

            protected Icon getClsIcon(Cls cls) {
                DisjointClassesTableModel disjointClassesTableModel = (DisjointClassesTableModel)DisjointClassesWidget.this.getTable().getModel();
                if (cls instanceof RDFResource) {
                    return disjointClassesTableModel.getIcon((RDFResource)cls);
                }
                return super.getClsIcon(cls);
            }
        }));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals("owl:disjointWith");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllSiblings(boolean bl) {
        SiblingsPanel siblingsPanel = new SiblingsPanel(this.mutuallyIsDefault);
        if (bl || ProtegeUI.getModalDialogFactory().showDialog((Component)((Object)this), siblingsPanel, "Remove siblings from disjoints", 11) == 1) {
            try {
                this.beginTransaction("Remove siblings from disjoints of " + this.getEditedCls().getBrowserText());
                this.mutuallyIsDefault = siblingsPanel.isMutuallySelected();
                OWLNamedClass oWLNamedClass = this.getEditedCls();
                if (this.mutuallyIsDefault) {
                    for (Cls cls : oWLNamedClass.getSuperclasses(false)) {
                        if (!(cls instanceof OWLNamedClass)) continue;
                        OWLUtil.removeSubclassesDisjoint((OWLNamedClass)cls);
                    }
                } else {
                    TripleStoreModel tripleStoreModel = oWLNamedClass.getOWLModel().getTripleStoreModel();
                    RDFProperty rDFProperty = oWLNamedClass.getOWLModel().getOWLDisjointWithProperty();
                    Set set = this.getPotentialDisjoints(oWLNamedClass);
                    for (OWLNamedClass oWLNamedClass2 : set) {
                        if (tripleStoreModel.isEditableTriple(oWLNamedClass, rDFProperty, oWLNamedClass2)) {
                            oWLNamedClass.removeDisjointClass(oWLNamedClass2);
                        }
                        if (!tripleStoreModel.isEditableTriple(oWLNamedClass2, rDFProperty, oWLNamedClass)) continue;
                        oWLNamedClass2.removeDisjointClass(oWLNamedClass);
                    }
                }
            }
            catch (Exception exception) {
                OWLUI.handleError(this.getOWLModel(), exception);
            }
            finally {
                this.endTransaction();
            }
        }
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
    }

    private class SiblingsPanel
    extends JPanel {
        private JRadioButton mutuallyRadioButton;
        private JRadioButton locallyRadioButton;

        SiblingsPanel(boolean bl) {
            this.mutuallyRadioButton = new JRadioButton("Mutually between all siblings", bl);
            this.locallyRadioButton = new JRadioButton("Only between this class and its siblings", !bl);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.mutuallyRadioButton);
            buttonGroup.add(this.locallyRadioButton);
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.mutuallyRadioButton);
            this.add(this.locallyRadioButton);
        }

        boolean isMutuallySelected() {
            return this.mutuallyRadioButton.isSelected();
        }
    }
}

