/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.Widget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.ui.cls.LogicClassDefinitionWidgetType;
import edu.stanford.smi.protegex.owl.ui.cls.PropertiesClassDefinitionWidgetType;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchableType;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.MultiWidgetPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.PropertyWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JPanel;

public class SwitchableClassDefinitionWidget
extends MultiWidgetPropertyWidget {
    private Widget activeWidget;
    private static List registry = new ArrayList();

    protected void createNestedWidgets() {
        String[] stringArray = new String[]{":DIRECT-TEMPLATE-SLOTS", ":DIRECT-SUPERCLASSES", ":DIRECT-INSTANCES", ":DIRECT-SUBCLASSES"};
        ArrayList arrayList = new ArrayList(PluginUtilities.getClassesWithAttribute((String)"ClassView", (String)"True"));
        for (Object object : arrayList) {
            try {
                SwitchableClassDefinitionWidget.registerSwitchableType((SwitchableType)((Class)object).newInstance());
            }
            catch (InstantiationException instantiationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", illegalAccessException);
            }
            catch (ClassCastException classCastException) {
                System.err.println("[SwitchableClassDefinitionWidget] plugin " + ((Class)object).getName() + " must implement SwitchableType - ignored");
            }
        }
        int n = 0;
        for (SwitchableType switchableType : registry) {
            Class clazz = switchableType.getWidgetClassType();
            try {
                PropertyWidget propertyWidget = (PropertyWidget)clazz.newInstance();
                this.addNestedWidget(propertyWidget, stringArray[n++], switchableType.getButtonText(), switchableType.getButtonText());
            }
            catch (Exception exception) {
                System.err.println("[SwitchableClassDefinitionWidget] " + exception);
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            }
        }
    }

    public Class getActiveWidgetClass() {
        if (this.activeWidget != null) {
            return this.activeWidget.getClass();
        }
        SwitchableType switchableType = (SwitchableType)registry.get(0);
        return switchableType.getWidgetClassType();
    }

    protected void initAllPanel(JPanel jPanel, List list) {
        jPanel.setLayout(new BorderLayout());
        if (this.activeWidget != null) {
            jPanel.add("Center", (Component)this.activeWidget);
        } else {
            jPanel.add("Center", (Component)this.listWidgets().next());
        }
    }

    public void initialize() {
        super.initialize();
        this.setAllMode(true);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        if (cls.getKnowledgeBase() instanceof OWLModel) {
            OWLNamedClass oWLNamedClass = ((OWLModel)cls.getKnowledgeBase()).getOWLNamedClassClass();
            return slot.getName().equals(":DIRECT-SUPERCLASSES") && facet == null && (oWLNamedClass.equals(cls) || cls.hasSuperclass((Cls)oWLNamedClass));
        }
        return false;
    }

    public static Iterator listSwitchableTypes() {
        return registry.iterator();
    }

    public static void registerSwitchableType(SwitchableType switchableType) {
        for (SwitchableType switchableType2 : registry) {
            if (switchableType2.getClass() != switchableType.getClass()) continue;
            return;
        }
        registry.add(switchableType);
    }

    public void setActiveType(Class clazz) {
        Iterator iterator = this.listWidgets();
        while (iterator.hasNext()) {
            Object object;
            PropertyWidget propertyWidget = (PropertyWidget)iterator.next();
            if (propertyWidget.getClass() != clazz) continue;
            this.activeWidget = propertyWidget;
            this.reinitAllPanel();
            this.revalidate();
            this.repaint();
            for (object = this; object != null && !(object instanceof ResourceDisplay); object = ((Component)object).getParent()) {
            }
            if (object instanceof ResourceDisplay) {
                ((ResourceDisplay)object).updateInferredModeOfWidgets();
            }
            return;
        }
    }

    static {
        registry.add(new LogicClassDefinitionWidgetType());
        registry.add(new PropertiesClassDefinitionWidgetType());
    }
}

