/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchiesHost;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyPanel;
import edu.stanford.smi.protegex.owl.ui.cls.SecondaryHierarchyPanel;
import edu.stanford.smi.protegex.owl.ui.subsumption.InferredSubsumptionTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class HierarchiesPanel
extends JPanel
implements HierarchyManager {
    private List hierarchyPanels = new ArrayList();
    private HierarchiesHost host;

    public HierarchiesPanel(HierarchiesHost hierarchiesHost) {
        this.host = hierarchiesHost;
    }

    public void addHierarchy(Hierarchy hierarchy) {
        SecondaryHierarchyPanel secondaryHierarchyPanel = new SecondaryHierarchyPanel(hierarchy, this);
        if (hierarchy.isDefaultSynchronized()) {
            secondaryHierarchyPanel.startSynchronize();
        }
        this.addHierarchyPanel(secondaryHierarchyPanel);
    }

    public void addHierarchyPanel(final HierarchyPanel hierarchyPanel) {
        this.hierarchyPanels.add(hierarchyPanel);
        this.setLayout(new BorderLayout());
        HierarchyPanel hierarchyPanel2 = (HierarchyPanel)this.hierarchyPanels.get(0);
        int n = hierarchyPanel2.getWidth();
        hierarchyPanel.setSize(n, hierarchyPanel2.getHeight());
        this.refillPanels();
        this.host.hierarchiesChanged(this.getWidth() + n);
        hierarchyPanel.getHierarchy().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                Cls cls;
                Hierarchy hierarchy;
                Collection collection;
                if (hierarchyPanel.isSynchronized() && (collection = (hierarchy = hierarchyPanel.getHierarchy()).getSelection()).size() == 1 && (cls = (Cls)collection.iterator().next()) instanceof RDFSNamedClass) {
                    HierarchiesPanel.this.synchronizePanels((RDFSNamedClass)cls);
                }
            }
        });
    }

    public void addHierarchyWindow(Hierarchy hierarchy) {
        HierarchyPanel hierarchyPanel = (HierarchyPanel)this.hierarchyPanels.get(0);
        int n = hierarchyPanel.getWidth();
        int n2 = hierarchyPanel.getHeight();
        final JFrame jFrame = ComponentFactory.createFrame();
        jFrame.setTitle(hierarchy.getTitle());
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", (Component)((Object)hierarchy));
        jFrame.setBounds(10, 10, n, n2);
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ComponentUtilities.dispose((Component)jFrame);
            }
        });
    }

    public void close(Hierarchy hierarchy) {
        HierarchyPanel hierarchyPanel = this.getHierarchyPanel(hierarchy);
        this.hierarchyPanels.remove(hierarchyPanel);
        ComponentUtilities.dispose((Component)hierarchyPanel);
        int n = this.getWidth();
        this.refillPanels();
        this.host.hierarchiesChanged(n - hierarchyPanel.getWidth());
    }

    public void closeInferredHierarchies() {
        ArrayList<Hierarchy> arrayList = new ArrayList<Hierarchy>();
        for (HierarchyPanel object : this.hierarchyPanels) {
            Hierarchy hierarchy = object.getHierarchy();
            if (!(hierarchy instanceof InferredSubsumptionTreePanel)) continue;
            arrayList.add(hierarchy);
        }
        for (Hierarchy hierarchy : arrayList) {
            this.close(hierarchy);
        }
    }

    public void expandRootsOfInferredTrees() {
        for (HierarchyPanel hierarchyPanel : this.hierarchyPanels) {
            Hierarchy hierarchy = hierarchyPanel.getHierarchy();
            if (!(hierarchy instanceof InferredSubsumptionTreePanel)) continue;
            ((InferredSubsumptionTreePanel)hierarchy).expandRoot();
        }
    }

    private HierarchyPanel getHierarchyPanel(Hierarchy hierarchy) {
        for (HierarchyPanel hierarchyPanel : this.hierarchyPanels) {
            if (hierarchyPanel.getHierarchy() != hierarchy) continue;
            return hierarchyPanel;
        }
        return null;
    }

    private boolean inferredHierarchyExists() {
        for (HierarchyPanel hierarchyPanel : this.hierarchyPanels) {
            if (!(hierarchyPanel.getHierarchy() instanceof InferredSubsumptionTreePanel)) continue;
            return true;
        }
        return false;
    }

    private void refillPanels() {
        this.removeAll();
        Component component = this.refillPanels(this.hierarchyPanels.iterator());
        this.add("Center", component);
        this.revalidate();
    }

    private Component refillPanels(Iterator iterator) {
        HierarchyPanel hierarchyPanel = (HierarchyPanel)iterator.next();
        if (iterator.hasNext()) {
            Component component = this.refillPanels(iterator);
            JSplitPane jSplitPane = new JSplitPane(1, hierarchyPanel, component);
            jSplitPane.setDividerLocation(hierarchyPanel.getWidth());
            jSplitPane.setOneTouchExpandable(true);
            return jSplitPane;
        }
        return hierarchyPanel;
    }

    public void showInferredHierarchy(OWLModel oWLModel) {
        if (!this.inferredHierarchyExists()) {
            InferredSubsumptionTreePanel inferredSubsumptionTreePanel = new InferredSubsumptionTreePanel(oWLModel);
            this.addHierarchy(inferredSubsumptionTreePanel);
            this.getTopLevelAncestor().validate();
        }
    }

    public void spawnHierarchy(Hierarchy hierarchy) {
        this.addHierarchyWindow(hierarchy);
    }

    private void synchronizePanels(RDFSNamedClass rDFSNamedClass) {
        for (HierarchyPanel hierarchyPanel : this.hierarchyPanels) {
            if (!hierarchyPanel.isSynchronized()) continue;
            hierarchyPanel.getHierarchy().setSelectedClass(rDFSNamedClass);
        }
    }
}

