/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteClassAction
extends ResourceAction {
    public static final String TEXT = "Delete class";

    public DeleteClassAction() {
        super(TEXT, OWLIcons.getDeleteClsIcon());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ClassTreePanel classTreePanel = (ClassTreePanel)((Object)this.getComponent());
        Collection collection = ComponentUtilities.getSelection((JTree)classTreePanel.getTree());
        DeleteClassAction.performAction(collection, classTreePanel);
    }

    private static boolean confirmDelete(Component component) {
        boolean bl = true;
        if (ProjectManager.getProjectManager().getCurrentProject().getDisplayConfirmationOnRemove()) {
            String string = LocalizedText.getText((ResourceKey)ResourceKey.DIALOG_CONFIRM_DELETE_TEXT);
            bl = ProtegeUI.getModalDialogFactory().showConfirmDialog(component, string, "Confirm Delete");
        }
        return bl;
    }

    @Override
    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return component instanceof ClassTreePanel && rDFResource instanceof RDFSNamedClass && rDFResource.isEditable();
    }

    public static void performAction(RDFSNamedClass rDFSNamedClass, ClassTreePanel classTreePanel) {
        DeleteClassAction.performAction(Collections.singleton(rDFSNamedClass), classTreePanel);
    }

    public static void performAction(Collection<RDFSNamedClass> collection, ClassTreePanel classTreePanel) {
        if (DeleteClassAction.confirmDelete((Component)((Object)classTreePanel))) {
            for (RDFSNamedClass rDFSNamedClass : collection) {
                Object object;
                if (rDFSNamedClass.getInstanceCount(true) > 0) {
                    object = LocalizedText.getText((ResourceKey)ResourceKey.DELETE_CLASS_FAILED_DIALOG_TEXT);
                    object = (String)object + "\n " + rDFSNamedClass.getBrowserText();
                    ProtegeUI.getModalDialogFactory().showMessageDialog(rDFSNamedClass.getOWLModel(), (String)object);
                    continue;
                }
                object = classTreePanel.getTree();
                ComponentUtilities.removeSelection((JTree)object);
                rDFSNamedClass.delete();
            }
        }
    }
}

