/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.form;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLExistentialRestriction;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.util.ClosureAxiomFactory;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchableType;
import edu.stanford.smi.protegex.owl.ui.widget.ClassFormWidget;
import java.util.ArrayList;
import java.util.List;

public class ClassFormSwitchableType
implements SwitchableType {
    public String getButtonText() {
        return "Form View";
    }

    private List getParentClasses(RDFSNamedClass rDFSNamedClass) {
        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
        for (RDFSClass rDFSClass : rDFSNamedClass.getSuperclasses(true)) {
            if (rDFSClass instanceof OWLIntersectionClass) {
                arrayList.addAll(((OWLIntersectionClass)rDFSClass).getOperands());
                continue;
            }
            arrayList.add(rDFSClass);
        }
        return arrayList;
    }

    public Class getWidgetClassType() {
        return ClassFormWidget.class;
    }

    private boolean isClosureAxiom(OWLNamedClass oWLNamedClass, List list, OWLAllValuesFrom oWLAllValuesFrom) {
        boolean bl = false;
        boolean bl2 = false;
        for (RDFSClass rDFSClass : list) {
            if (!(rDFSClass instanceof OWLExistentialRestriction)) continue;
            bl = true;
            OWLExistentialRestriction oWLExistentialRestriction = (OWLExistentialRestriction)rDFSClass;
            OWLAllValuesFrom oWLAllValuesFrom2 = ClosureAxiomFactory.getClosureAxiom(oWLNamedClass, oWLExistentialRestriction);
            if (!oWLAllValuesFrom.equals(oWLAllValuesFrom2)) continue;
            bl2 = true;
            break;
        }
        return bl && bl2;
    }

    public boolean isSufficientlyExpressive(RDFSNamedClass rDFSNamedClass) {
        if (rDFSNamedClass instanceof OWLNamedClass) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSNamedClass;
            if (oWLNamedClass.getEquivalentClasses().size() > 1) {
                return false;
            }
            List list = this.getParentClasses(rDFSNamedClass);
            for (RDFSClass rDFSClass : list) {
                if (rDFSClass instanceof OWLLogicalClass || rDFSClass instanceof OWLCardinalityBase) {
                    return false;
                }
                if (!(rDFSClass instanceof OWLAllValuesFrom) || this.isClosureAxiom(oWLNamedClass, list, (OWLAllValuesFrom)rDFSClass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSuitable(OWLModel oWLModel) {
        return true;
    }
}

