/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.component.property;

import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormTable;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;

public class ChangeClosureAxiomButton
extends AbstractAction {
    private JButton button;
    private static final String CLOSED_TEXT = "Remove closure axiom (Allow other values)";
    private static final String OPEN_TEXT = "Add closure axiom (Don't allow other values)";
    private PropertyFormTable table;

    public ChangeClosureAxiomButton(PropertyFormTable propertyFormTable) {
        super(CLOSED_TEXT, OWLIcons.getImageIcon("ClosureClosed"));
        this.table = propertyFormTable;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.table.setClosed(!this.table.isClosed());
        this.updateButton();
    }

    public void init(JButton jButton) {
        this.button = jButton;
        this.updateButton();
    }

    private void updateButton() {
        boolean bl = this.table.isClosed();
        this.button.setToolTipText(bl ? CLOSED_TEXT : OPEN_TEXT);
        this.button.setIcon(OWLIcons.getImageIcon(bl ? "ClosureClosed" : "ClosureOpen"));
    }
}

