/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.Deprecatable;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.manchester.ManchesterOWLParserUtil;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.Icon;

public class ResourceRenderer
extends FrameRenderer {
    private Frame focusedFrame;
    protected RDFSClass loadedClass;
    protected SimpleInstance loadedInstance;
    public static final Color FOCUS_COLOR = new Color(128, 0, 255);
    private Slot directSuperclassesSlot;
    private HashMap colorMap;
    private HashMap greyedColorMap;
    private static final Color RESTRICTION_KEYWORD_COLOR = Color.MAGENTA.darker();
    private static final Color GREYED_RESTRICTION_KEYWORD_COLOR = new Color(180, 100, 200);
    private static final Color LOGICAL_OPERAND_KEYWORD_COLOR = Color.CYAN.darker();
    private static final Color GREYED_LOGICAL_OPERAND_COLOR = new Color(120, 160, 245);
    private static final Color COMMENT_COLOR = Color.GRAY;

    public ResourceRenderer() {
        this(null);
    }

    public ResourceRenderer(Slot slot) {
        this.directSuperclassesSlot = slot;
        this.setDisplayHiddenIcon(false);
        this.colorMap = new HashMap();
        this.greyedColorMap = new HashMap();
        this.addKeyword(ManchesterOWLParserUtil.getMinKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getExactKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getMaxKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getSomeKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getAllKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getHasKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getAndKeyword(), LOGICAL_OPERAND_KEYWORD_COLOR, GREYED_LOGICAL_OPERAND_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getOrKeyword(), LOGICAL_OPERAND_KEYWORD_COLOR, GREYED_LOGICAL_OPERAND_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getNotKeyword(), LOGICAL_OPERAND_KEYWORD_COLOR, GREYED_LOGICAL_OPERAND_COLOR);
    }

    protected void addKeyword(String string, Color color, Color color2) {
        this.colorMap.put(string, color);
        this.colorMap.put(string.toLowerCase(), color);
        this.colorMap.put(string.toUpperCase(), color);
        this.greyedColorMap.put(string, color2);
        this.greyedColorMap.put(string.toLowerCase(), color2);
        this.greyedColorMap.put(string.toUpperCase(), color2);
    }

    public static void addAnnotationFlag(FrameRenderer frameRenderer, Cls cls) {
        for (Slot slot : cls.getKnowledgeBase().getSlots()) {
            if (!(slot instanceof OWLProperty) || !((OWLProperty)slot).isAnnotationProperty() || cls.getDirectOwnSlotValues(slot).size() <= 0) continue;
            frameRenderer.appendIcon((Icon)OWLIcons.getImageIcon("Annotations"));
            return;
        }
    }

    private void addInverseSlot(Slot slot) {
        Slot slot2 = slot.getInverseSlot();
        if (slot2 != null) {
            this.appendText(" \u2194 " + slot2.getBrowserText());
        }
    }

    private void addNamedEquivalentClses(OWLNamedClass oWLNamedClass) {
        for (Cls cls : oWLNamedClass.getDirectOwnSlotValues(this.directSuperclassesSlot)) {
            OWLNamedClass oWLNamedClass2;
            if (!(cls instanceof OWLNamedClass) || !(oWLNamedClass2 = (OWLNamedClass)cls).getDirectOwnSlotValues(this.directSuperclassesSlot).contains(oWLNamedClass)) continue;
            this.appendText(" \u2261 " + oWLNamedClass2.getBrowserText());
        }
    }

    protected Icon getClsIcon(Cls cls) {
        return cls.getIcon();
    }

    private Color getTextColor(String string) {
        Color color = null;
        color = !this._grayedText ? (Color)this.colorMap.get(string) : (Color)this.greyedColorMap.get(string);
        return color;
    }

    protected void paintString(Graphics graphics, String string, Point point, Color color, Dimension dimension) {
        if (this.loadedClass != null) {
            if (this.loadedClass instanceof OWLClass) {
                if (color != null) {
                    graphics.setColor(color);
                }
                int n = (dimension.height + this._fontMetrics.getAscent()) / 2 - 2;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ()[]{}", true);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    Color color2 = graphics.getColor();
                    Font font = graphics.getFont();
                    Color color3 = null;
                    int n2 = 0;
                    if (this.loadedClass instanceof OWLAnonymousClass) {
                        if (string.startsWith("//")) {
                            color3 = COMMENT_COLOR;
                            n2 = 2;
                        } else {
                            color3 = this.getTextColor(string2);
                            n2 = 1;
                        }
                    }
                    if (color3 != null) {
                        graphics.setColor(color3);
                        graphics.setFont(graphics.getFont().deriveFont(n2));
                    } else {
                        RDFResource rDFResource;
                        OWLModel oWLModel = this.loadedClass.getOWLModel();
                        if (oWLModel instanceof JenaOWLModel && (rDFResource = oWLModel.getRDFResource(string2)) instanceof OWLNamedClass && !((OWLNamedClass)rDFResource).isConsistent()) {
                            graphics.setColor(Color.RED);
                            graphics.setFont(graphics.getFont().deriveFont(1));
                        }
                    }
                    graphics.drawString(string2, point.x, n);
                    point.x += graphics.getFontMetrics().stringWidth(string2);
                    graphics.setColor(color2);
                    graphics.setFont(font);
                }
            } else {
                super.paintString(graphics, string, point, color, dimension);
            }
        } else {
            if (this.loadedInstance != null) {
                OWLModel oWLModel = ((RDFResource)this.loadedInstance).getOWLModel();
                if (this.loadedInstance.getDirectType() == oWLModel.getOWLOntologyClass() && !((DefaultOWLOntology)this.loadedInstance).isAssociatedTriplestoreEditable()) {
                    color = Color.GRAY;
                    graphics.setFont(graphics.getFont().deriveFont(2));
                }
            }
            super.paintString(graphics, string, point, color, dimension);
        }
    }

    protected void loadCls(Cls cls) {
        this.setMainIcon(this.getClsIcon(cls));
        this.loadClsAfterIcon(cls);
    }

    public void load(Object object) {
        super.load(object);
        if (object instanceof RDFSClass) {
            this.loadedClass = (RDFSClass)object;
        } else if (object instanceof SimpleInstance) {
            this.loadedInstance = (SimpleInstance)object;
        }
    }

    protected void loadClsAfterIcon(Cls cls) {
        this.setMainText(cls.getBrowserText());
        this.appendText(this.getInstanceCountString(cls));
        this.setBackgroundSelectionColor(Colors.getClsSelectionColor());
        if (cls instanceof RDFSClass) {
            if (cls instanceof OWLAnonymousClass) {
                ResourceRenderer.addAnnotationFlag(this, cls);
            } else if (this.directSuperclassesSlot != null && cls instanceof OWLNamedClass) {
                this.addNamedEquivalentClses((OWLNamedClass)cls);
            }
            if (cls instanceof Deprecatable && ((Deprecatable)cls).isDeprecated()) {
                this.addIcon(OWLIcons.getDeprecatedIcon());
            }
            this.loadedClass = (RDFSClass)cls;
        } else {
            this.loadedClass = null;
        }
    }

    protected void loadSlot(Slot slot) {
        super.loadSlot(slot);
        this.addInverseSlot(slot);
        if (slot instanceof Deprecatable && ((Deprecatable)slot).isDeprecated()) {
            this.addIcon(OWLIcons.getDeprecatedIcon());
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.loadedClass != null && this.focusedFrame != null) {
            int n = 3;
            int n2 = n + this.getMainIcon().getIconWidth();
            String string = this.getMainText();
            int n3 = string.length();
            String string2 = this.focusedFrame.getBrowserText();
            int n4 = string2.length();
            for (int i = 0; i < n3; ++i) {
                if (i != 0 && this.isOWLNameCharacter(string.charAt(i - 1)) || !string.regionMatches(i, string2, 0, n4) || i + n4 < n3 && this.isOWLNameCharacter(string.charAt(i + n4))) continue;
                graphics.setColor(FOCUS_COLOR);
                int n5 = n2 + this._fontMetrics.stringWidth(string.substring(0, i));
                int n6 = this.getHeight() - 1;
                int n7 = this._fontMetrics.stringWidth(string2);
                graphics.drawRect(n5 - 1, 0, n7 + 2, n6);
                i += n4;
            }
        }
    }

    private boolean isOWLNameCharacter(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-';
    }

    public void setFocusedFrame(Frame frame) {
        this.focusedFrame = frame;
    }
}

