/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.todo;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFResourceTest;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TodoAnnotationOWLTest
extends AbstractOWLTest
implements RDFResourceTest {
    public static final String GROUP = "Maintenance Tests";

    public TodoAnnotationOWLTest() {
        super(GROUP, null);
    }

    public String getName() {
        return "Find TODO list items";
    }

    public static List getTODOListItems(RDFResource rDFResource) {
        ArrayList arrayList = new ArrayList();
        OWLModel oWLModel = rDFResource.getOWLModel();
        OWLDatatypeProperty oWLDatatypeProperty = oWLModel.getTodoAnnotationProperty();
        String string = oWLModel.getTodoAnnotationPrefix();
        for (Object object : rDFResource.getPropertyValues(oWLDatatypeProperty)) {
            String string2 = null;
            if (object instanceof RDFSLiteral) {
                string2 = ((RDFSLiteral)object).getString();
                object = string2;
            } else {
                string2 = object.toString();
            }
            if (!string2.startsWith(string)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public List test(RDFResource rDFResource) {
        List list = TodoAnnotationOWLTest.getTODOListItems(rDFResource);
        if (list.size() > 0) {
            ArrayList<1> arrayList = new ArrayList<1>();
            for (final String string : list) {
                arrayList.add(new DefaultOWLTestResult(string, rDFResource, 2, this, OWLIcons.getTODOIcon()){

                    public String toString() {
                        return "TODO (at " + this.getHost().getBrowserText() + "): " + string;
                    }
                });
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }
}

