/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InversePropertyMustHaveMatchingRangeAndDomainTest
extends AbstractOWLTest
implements RepairableOWLTest,
RDFPropertyTest {
    public InversePropertyMustHaveMatchingRangeAndDomainTest() {
        super("Sanity Tests", null);
    }

    private static boolean equalCollections(Collection collection, Collection collection2) {
        return collection.containsAll(collection2) && collection2.containsAll(collection);
    }

    public static boolean fails(RDFProperty rDFProperty) {
        if (rDFProperty instanceof OWLObjectProperty && ((OWLObjectProperty)rDFProperty).getInverseProperty() instanceof OWLObjectProperty) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)rDFProperty.getInverseProperty();
            if (!rDFProperty.isDomainDefined() || !oWLObjectProperty.isDomainDefined()) {
                return false;
            }
            Collection collection = rDFProperty.getUnionDomain();
            Collection collection2 = rDFProperty.getUnionRangeClasses();
            Collection collection3 = oWLObjectProperty.getUnionDomain();
            Collection collection4 = oWLObjectProperty.getUnionRangeClasses();
            return !InversePropertyMustHaveMatchingRangeAndDomainTest.equalCollections(collection, collection4) || !InversePropertyMustHaveMatchingRangeAndDomainTest.equalCollections(collection2, collection3);
        }
        return false;
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        OWLProperty oWLProperty = (OWLProperty)oWLTestResult.getHost();
        if (InversePropertyMustHaveMatchingRangeAndDomainTest.fails(oWLProperty) && oWLProperty instanceof OWLObjectProperty && ((OWLObjectProperty)oWLProperty).getInverseProperty() instanceof OWLObjectProperty) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)oWLProperty.getInverseProperty();
            if (oWLProperty.isDomainDefined() && oWLObjectProperty.isDomainDefined()) {
                Collection collection = oWLObjectProperty.getUnionDomain();
                Collection collection2 = oWLObjectProperty.getUnionRangeClasses();
                oWLProperty.setUnionRangeClasses(collection);
                ArrayList arrayList = new ArrayList(oWLProperty.getUnionDomain());
                for (RDFSClass rDFSClass : arrayList) {
                    oWLProperty.removeUnionDomainClass(rDFSClass);
                }
                for (RDFSClass rDFSClass : collection2) {
                    oWLProperty.addUnionDomainClass(rDFSClass);
                }
            }
        }
        return !InversePropertyMustHaveMatchingRangeAndDomainTest.fails(oWLProperty);
    }

    public List test(RDFProperty rDFProperty) {
        if (InversePropertyMustHaveMatchingRangeAndDomainTest.fails(rDFProperty)) {
            return Collections.singletonList(new DefaultOWLTestResult("Inverse properties must have inverse domains and ranges.", rDFProperty, 1, this));
        }
        return Collections.EMPTY_LIST;
    }
}

