/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.owldl;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLDLTest;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NoCardiRestrictionOnTransitivePropertiesOWLDLTest
extends AbstractOWLTest
implements OWLDLTest,
RDFSClassTest {
    public NoCardiRestrictionOnTransitivePropertiesOWLDLTest() {
        super("OWL-DL Tests", null);
    }

    public static boolean fails(RDFSClass rDFSClass) {
        if (rDFSClass instanceof OWLCardinalityBase) {
            OWLCardinalityBase oWLCardinalityBase = (OWLCardinalityBase)rDFSClass;
            RDFProperty rDFProperty = oWLCardinalityBase.getOnProperty();
            return NoCardiRestrictionOnTransitivePropertiesOWLDLTest.isTransitive(rDFProperty, new HashSet());
        }
        return false;
    }

    private static boolean isTransitive(Slot slot, Set set) {
        if (!set.contains(slot)) {
            set.add(slot);
            if (slot instanceof OWLObjectProperty) {
                OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)slot;
                if (oWLObjectProperty.isTransitive()) {
                    return true;
                }
                for (Slot slot2 : slot.getDirectSubslots()) {
                    if (!NoCardiRestrictionOnTransitivePropertiesOWLDLTest.isTransitive(slot2, set)) continue;
                    return true;
                }
                Slot slot3 = slot.getInverseSlot();
                if (slot3 != null && NoCardiRestrictionOnTransitivePropertiesOWLDLTest.isTransitive(slot3, set)) {
                    return true;
                }
            }
        }
        return false;
    }

    public List test(RDFSClass rDFSClass) {
        if (NoCardiRestrictionOnTransitivePropertiesOWLDLTest.fails(rDFSClass)) {
            return Collections.singletonList(new DefaultOWLTestResult("Cardinality restrictions on transitive properties (or inverse or super properties of them) are not allowed in OWL DL.", rDFSClass, 3, this));
        }
        return Collections.EMPTY_LIST;
    }
}

