/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineManager;
import edu.stanford.smi.protegex.owl.swrl.bridge.ui.ViewRuleEngineAction;
import edu.stanford.smi.protegex.owl.swrl.ui.actions.EditRuleAction;
import edu.stanford.smi.protegex.owl.swrl.ui.tab.SWRLTab;
import edu.stanford.smi.protegex.owl.swrl.ui.table.CloneRuleAction;
import edu.stanford.smi.protegex.owl.swrl.ui.table.CreateRuleAction;
import edu.stanford.smi.protegex.owl.swrl.ui.table.DeleteRuleAction;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTable;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTableModel;
import edu.stanford.smi.protegex.owl.swrl.ui.table.ViewRuleAction;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class SWRLTablePanel
extends JPanel
implements Disposable {
    private EditRuleAction editRuleAction;
    private SWRLTable table;
    private SWRLTableModel tableModel;

    public SWRLTablePanel(OWLModel oWLModel, RDFResource rDFResource) {
        this.initialize(oWLModel, rDFResource);
    }

    public SWRLTablePanel(OWLModel oWLModel, RDFResource rDFResource, SWRLTab sWRLTab) {
        LabeledComponent labeledComponent = this.initialize(oWLModel, rDFResource);
        for (SWRLRuleEngineManager.RuleEngineRegistrationInfo ruleEngineRegistrationInfo : SWRLRuleEngineManager.getRegisteredRuleEngines()) {
            labeledComponent.addHeaderButton((Action)new ViewRuleEngineAction(ruleEngineRegistrationInfo.getRuleEngineName(), ruleEngineRegistrationInfo.getToolTip(), ruleEngineRegistrationInfo.getIcon(), sWRLTab, oWLModel));
            this.add("Center", (Component)labeledComponent);
        }
    }

    public void dispose() {
        this.table.dispose();
    }

    private LabeledComponent initialize(OWLModel oWLModel, RDFResource rDFResource) {
        this.tableModel = rDFResource == null ? new SWRLTableModel(oWLModel) : new SWRLTableModel(rDFResource);
        this.table = new SWRLTable(this.tableModel, oWLModel);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.table));
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("SWRL Rules", jScrollPane);
        oWLLabeledComponent.addHeaderButton(new ViewRuleAction(this.table));
        oWLLabeledComponent.addHeaderButton(new CreateRuleAction(this.table, oWLModel));
        oWLLabeledComponent.addHeaderButton(new CloneRuleAction(this.table, oWLModel));
        oWLLabeledComponent.addHeaderButton(new DeleteRuleAction(this.table));
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
        return oWLLabeledComponent;
    }
}

