/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSymbolPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLTextArea;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SWRLTextAreaPanel
extends JPanel
implements ModalDialogFactory.CloseCallback {
    private OWLModel owlModel;
    private SWRLSymbolPanel symbolPanel;
    private SWRLTextArea textArea;

    public SWRLTextAreaPanel(OWLModel oWLModel) {
        this(oWLModel, null);
    }

    public SWRLTextAreaPanel(OWLModel oWLModel, SWRLImp sWRLImp) {
        String string;
        this.owlModel = oWLModel;
        this.symbolPanel = new SWRLSymbolPanel(oWLModel, false, false);
        this.textArea = new SWRLTextArea(oWLModel, this.symbolPanel){

            protected void checkExpression(String string) throws Throwable {
                SWRLTextAreaPanel.this.owlModel.getOWLClassDisplay().getParser().checkClass(SWRLTextAreaPanel.this.owlModel, string);
            }
        };
        if (sWRLImp != null && sWRLImp.getHead() != null) {
            string = sWRLImp.getBrowserText();
            this.textArea.setText(string);
            this.textArea.reformatText();
        }
        this.symbolPanel.setSymbolEditor(this.textArea);
        string = new InstanceDisplay(oWLModel.getProject(), false, false);
        string.setInstance((Instance)sWRLImp);
        this.setLayout(new BorderLayout(0, 8));
        this.add("North", (Component)((Object)string));
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setPreferredSize(new Dimension(100, 250));
        this.add("Center", jScrollPane);
        this.add("South", this.symbolPanel);
    }

    public boolean canClose(int n) {
        if (n == 1) {
            String string = this.textArea.getText();
            if (string.length() == 0) {
                return false;
            }
            try {
                SWRLParser sWRLParser = new SWRLParser(this.owlModel);
                sWRLParser.parse(string);
                return true;
            }
            catch (Exception exception) {
                this.symbolPanel.displayError(exception);
                return false;
            }
        }
        return true;
    }

    public SWRLImp getResultAsImp() {
        try {
            String string = this.textArea.getText();
            SWRLParser sWRLParser = new SWRLParser(this.owlModel);
            sWRLParser.setParseOnly(false);
            return sWRLParser.parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getResultAsString() {
        return this.textArea.getText();
    }

    public static boolean showEditDialog(Component component, OWLModel oWLModel, SWRLImp sWRLImp) {
        SWRLTextAreaPanel sWRLTextAreaPanel = new SWRLTextAreaPanel(oWLModel, sWRLImp);
        String string = "Edit SWRL Rule";
        if (ProtegeUI.getModalDialogFactory().showDialog(component, sWRLTextAreaPanel, string, 11, sWRLTextAreaPanel) == 1) {
            try {
                sWRLImp.setExpression(sWRLTextAreaPanel.getResultAsString());
                return true;
            }
            catch (Exception exception) {
                System.err.println("[SWRLTextAreaPanel]  Fatal error");
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            }
        }
        return false;
    }
}

