/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.parser;

import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLIncompleteRuleException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class SWRLParser {
    public static final char AND_CHAR = '\u2227';
    public static final char IMP_CHAR = '\u2192';
    private OWLModel owlModel;
    private SWRLFactory swrlFactory;
    private boolean parseOnly;
    private StringTokenizer tokenizer;
    private String delimiters = " ?\n\t()[],#\"\u2227\u2192";
    private Collection xmlSchemaSymbols = XMLSchemaDatatypes.getSlotSymbols();
    private HashSet variables;
    private boolean inHead = false;

    public SWRLParser(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.swrlFactory = new SWRLFactory(oWLModel);
        this.parseOnly = true;
        this.variables = new HashSet();
    }

    public void setParseOnly(boolean bl) {
        this.parseOnly = bl;
    }

    public SWRLImp parse(String string) throws SWRLParseException {
        return this.parse(string, null);
    }

    public SWRLImp parse(String string, SWRLImp sWRLImp) throws SWRLParseException {
        SWRLAtomList sWRLAtomList = null;
        SWRLAtomList sWRLAtomList2 = null;
        SWRLAtom sWRLAtom = null;
        boolean bl = false;
        boolean bl2 = false;
        this.inHead = false;
        this.variables.clear();
        this.tokenizer = new StringTokenizer(string.trim(), this.delimiters, true);
        if (!this.parseOnly) {
            sWRLAtomList = this.swrlFactory.createAtomList();
            sWRLAtomList2 = this.swrlFactory.createAtomList();
        }
        if (!this.parseOnly && !this.tokenizer.hasMoreTokens()) {
            throw new SWRLParseException("Empty rule.");
        }
        do {
            String string2 = bl2 ? (this.inHead ? "Expecting '\u2227'" : "Expecting '\u2192' or '\u2227'") : (this.inHead ? "Expecting atom." : "Expecting atom or '\u2192'.");
            String string3 = this.getNextNonSpaceToken(string2);
            if (string3.equals("\u2192")) {
                if (this.inHead) {
                    throw new SWRLParseException("Second occurence of '\u2192'.");
                }
                this.inHead = true;
                bl2 = false;
                continue;
            }
            if (string3.equals("-") || string3.equals("->")) continue;
            if (string3.equals("\u2227")) {
                if (!bl2) {
                    throw new SWRLParseException("'\u2227' may occur only after an atom.");
                }
                bl2 = false;
                continue;
            }
            sWRLAtom = this.parseAtom(string3);
            bl = true;
            if (!this.parseOnly) {
                if (this.inHead) {
                    sWRLAtomList.append(sWRLAtom);
                } else {
                    sWRLAtomList2.append(sWRLAtom);
                }
            }
            bl2 = true;
        } while (this.tokenizer.hasMoreTokens());
        if (!this.parseOnly) {
            if (!bl) {
                throw new SWRLParseException("Incomplete rule - no antecedent or consequent.");
            }
            if (sWRLImp == null) {
                sWRLImp = this.swrlFactory.createImp(sWRLAtomList, sWRLAtomList2);
            } else {
                sWRLImp.setHead(sWRLAtomList);
                sWRLImp.setBody(sWRLAtomList2);
            }
        } else {
            sWRLImp = null;
        }
        return sWRLImp;
    }

    private SWRLAtom parseAtom(String string) throws SWRLParseException {
        SWRLAtom sWRLAtom = null;
        List list = null;
        boolean bl = false;
        this.checkThatIdentifierIsValid(string);
        if (string.startsWith("[")) {
            list = this.parseDObjectList();
            bl = true;
        }
        if (bl) {
            this.checkAndSkipToken("(", "Expecting parameters enclosed in parentheses for data range atom.");
        } else {
            this.checkAndSkipToken("(", "Expecting parameters enclosed in parentheses for atom '" + string + "'.");
        }
        if (bl) {
            sWRLAtom = this.parseEnumeratedListParameters(list);
        } else if (this.isSameAs(string)) {
            sWRLAtom = this.parseSameAsAtomParameters();
        } else if (this.isDifferentFrom(string)) {
            sWRLAtom = this.parseDifferentFromAtomParameters();
        } else if (this.isOWLClassName(string)) {
            sWRLAtom = this.parseClassAtomParameters(string);
        } else if (this.isOWLObjectPropertyName(string)) {
            sWRLAtom = this.parseIndividualPropertyAtomParameters(string);
        } else if (this.isOWLDatatypePropertyName(string)) {
            sWRLAtom = this.parseDatavaluedPropertyAtomParameters(string);
        } else if (this.isBuiltinName(string)) {
            sWRLAtom = this.parseBuiltinParameters(string);
        } else if (this.isXSDDatatype(string)) {
            sWRLAtom = this.parseXSDDatatypeParameters(string);
        } else {
            throw new SWRLParseException("Invalid atom name '" + string + "'.");
        }
        return sWRLAtom;
    }

    private void checkAndSkipToken(String string, String string2) throws SWRLParseException {
        String string3 = this.getNextNonSpaceToken(string2);
        if (!string3.equalsIgnoreCase(string)) {
            throw new SWRLParseException("Expecting '" + string + "', got '" + string3 + "'. " + string2);
        }
    }

    private String getNextStringToken(String string) throws SWRLParseException {
        String string2 = "";
        String string3 = "Incomplete rule. " + string;
        if (!this.tokenizer.hasMoreTokens()) {
            if (this.parseOnly) {
                throw new SWRLIncompleteRuleException(string3);
            }
            throw new SWRLParseException(string3);
        }
        if (this.tokenizer.hasMoreTokens()) {
            string2 = this.tokenizer.nextToken("\"");
            return string2;
        }
        if (this.parseOnly) {
            throw new SWRLIncompleteRuleException(string3);
        }
        throw new SWRLParseException(string3);
    }

    private String getNextNonSpaceToken(String string) throws SWRLParseException {
        String string2 = "";
        String string3 = "Incomplete rule. " + string;
        if (!this.tokenizer.hasMoreTokens()) {
            if (this.parseOnly) {
                throw new SWRLIncompleteRuleException(string3);
            }
            throw new SWRLParseException(string3);
        }
        while (this.tokenizer.hasMoreTokens()) {
            string2 = this.tokenizer.nextToken(this.delimiters);
            if (string2.equals(" ") || string2.equals("\n") || string2.equals("\t")) continue;
            return string2;
        }
        if (this.parseOnly) {
            throw new SWRLIncompleteRuleException(string3);
        }
        throw new SWRLParseException(string3);
    }

    private boolean hasMoreNonSpaceTokens() {
        if (!this.tokenizer.hasMoreTokens()) {
            return false;
        }
        while (this.tokenizer.hasMoreTokens()) {
            String string = this.tokenizer.nextToken(this.delimiters);
            if (string.equals(" ") || string.equals("\n") || string.equals("\t")) continue;
            return true;
        }
        return false;
    }

    private SWRLAtom parseSameAsAtomParameters() throws SWRLParseException {
        SWRLSameIndividualAtom sWRLSameIndividualAtom = null;
        RDFResource rDFResource = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameter for SameAsAtom.");
        RDFResource rDFResource2 = this.parseIObject();
        if (!this.parseOnly) {
            sWRLSameIndividualAtom = this.swrlFactory.createSameIndividualAtom(rDFResource, rDFResource2);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after second parameters in SameAsAtom");
        return sWRLSameIndividualAtom;
    }

    private SWRLAtom parseDifferentFromAtomParameters() throws SWRLParseException {
        SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom = null;
        RDFResource rDFResource = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameters for DifferentFromAtom");
        RDFResource rDFResource2 = this.parseIObject();
        if (!this.parseOnly) {
            sWRLDifferentIndividualsAtom = this.swrlFactory.createDifferentIndividualsAtom(rDFResource, rDFResource2);
        }
        this.checkAndSkipToken(")", "Only two parameters allowed for DifferentFromAtom");
        return sWRLDifferentIndividualsAtom;
    }

    private SWRLAtom parseClassAtomParameters(String string) throws SWRLParseException {
        SWRLClassAtom sWRLClassAtom = null;
        RDFResource rDFResource = this.parseIObject();
        if (!this.parseOnly) {
            OWLNamedClass oWLNamedClass = this.owlModel.getOWLNamedClass(string);
            sWRLClassAtom = this.swrlFactory.createClassAtom(oWLNamedClass, rDFResource);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis for parameter for ClassAtom '" + string + "'.");
        return sWRLClassAtom;
    }

    private SWRLAtom parseIndividualPropertyAtomParameters(String string) throws SWRLParseException {
        SWRLIndividualPropertyAtom sWRLIndividualPropertyAtom = null;
        RDFResource rDFResource = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameter for IndividualPropertyAtom '" + string + "'");
        RDFResource rDFResource2 = this.parseIObject();
        if (!this.parseOnly) {
            OWLObjectProperty oWLObjectProperty = this.owlModel.getOWLObjectProperty(string);
            if (oWLObjectProperty == null) {
                throw new SWRLParseException("no datatype slot found for IndividualPropertyAtom: " + string);
            }
            sWRLIndividualPropertyAtom = this.swrlFactory.createIndividualPropertyAtom(oWLObjectProperty, rDFResource, rDFResource2);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after second parameter of IndividualPropertyAtom '" + string + "'.");
        return sWRLIndividualPropertyAtom;
    }

    private SWRLAtom parseDatavaluedPropertyAtomParameters(String string) throws SWRLParseException {
        SWRLDatavaluedPropertyAtom sWRLDatavaluedPropertyAtom = null;
        String string2 = "Expecting literal qualification symbol '#' or closing parenthesis after second parameter of DatavaluedPropertyAtom' ";
        RDFResource rDFResource = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameter for DatavaluedPropertyAtom '" + string + "'.");
        RDFObject rDFObject = this.parseDObject();
        String string3 = this.getNextNonSpaceToken(string2 + string + "'.");
        if (string3.equals("#")) {
            string3 = this.getNextNonSpaceToken("Expecting XML Schema datatype.");
            if (this.tokenizer.hasMoreTokens() && !this.isXSDDatatype(string3)) {
                throw new SWRLParseException("Invalid XML Schema datatype name: '" + string3 + "'.");
            }
            if (!this.parseOnly) {
                rDFObject = this.owlModel.createRDFSLiteral(rDFObject.getBrowserText(), string3);
            }
            this.checkAndSkipToken(")", "Expecting closing parenthesis after second parameter of DatavaluedPropertyAtom");
        } else if (!string3.equals(")")) {
            throw new SWRLParseException(string2 + string + "'.");
        }
        if (!this.parseOnly) {
            OWLDatatypeProperty oWLDatatypeProperty = this.owlModel.getOWLDatatypeProperty(string);
            sWRLDatavaluedPropertyAtom = this.swrlFactory.createDatavaluedPropertyAtom(oWLDatatypeProperty, rDFResource, rDFObject);
        }
        return sWRLDatavaluedPropertyAtom;
    }

    private SWRLAtom parseBuiltinParameters(String string) throws SWRLParseException {
        SWRLBuiltinAtom sWRLBuiltinAtom = null;
        List list = new ArrayList();
        list = this.parseObjectList();
        if (!this.parseOnly) {
            SWRLBuiltin sWRLBuiltin = this.swrlFactory.getBuiltin(string);
            sWRLBuiltinAtom = this.swrlFactory.createBuiltinAtom(sWRLBuiltin, list.iterator());
        }
        return sWRLBuiltinAtom;
    }

    private SWRLAtom parseXSDDatatypeParameters(String string) throws SWRLParseException {
        SWRLDataRangeAtom sWRLDataRangeAtom = null;
        RDFObject rDFObject = this.parseDObject();
        if (!this.parseOnly) {
            RDFSDatatype rDFSDatatype = this.owlModel.getRDFSDatatypeByName(string);
            sWRLDataRangeAtom = this.swrlFactory.createDataRangeAtom(rDFSDatatype, rDFObject);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after DataRangeAtom '" + string + "'.");
        return sWRLDataRangeAtom;
    }

    private SWRLAtom parseEnumeratedListParameters(List list) throws SWRLParseException {
        SWRLDataRangeAtom sWRLDataRangeAtom = null;
        RDFObject rDFObject = this.parseDObject();
        if (!this.parseOnly) {
            OWLDataRange oWLDataRange = this.owlModel.createOWLDataRange();
            RDFProperty rDFProperty = this.owlModel.getOWLOneOfProperty();
            for (Object e : list) {
                oWLDataRange.addPropertyValue(rDFProperty, e);
            }
            sWRLDataRangeAtom = this.swrlFactory.createDataRangeAtom(oWLDataRange, rDFObject);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after parameter in DataRangeAtom.");
        return sWRLDataRangeAtom;
    }

    private List parseDObjectList() throws SWRLParseException {
        ArrayList<RDFObject> arrayList = null;
        if (!this.parseOnly) {
            arrayList = new ArrayList<RDFObject>();
        }
        RDFObject rDFObject = this.parseDObject();
        if (!this.parseOnly) {
            arrayList.add(rDFObject);
        }
        String string = this.getNextNonSpaceToken("Expecting additional comma-separated variables or literals or closing parenthesis.");
        while (string.equals(",")) {
            rDFObject = this.parseDObject();
            if (!this.parseOnly) {
                arrayList.add(rDFObject);
            }
            if ((string = this.getNextNonSpaceToken("Expecting ',' or ')'.")).equals(",") || string.equals(")")) continue;
            throw new SWRLParseException("Expecting ',' or ')', got '" + string + "'.");
        }
        return arrayList;
    }

    private List parseObjectList() throws SWRLParseException {
        ArrayList<RDFObject> arrayList = null;
        if (!this.parseOnly) {
            arrayList = new ArrayList<RDFObject>();
        }
        RDFObject rDFObject = this.parseObject();
        if (!this.parseOnly) {
            arrayList.add(rDFObject);
        }
        String string = this.getNextNonSpaceToken("Expecting additional comma-separated variables, literals or individual names or closing parenthesis.");
        while (string.equals(",")) {
            rDFObject = this.parseObject();
            if (!this.parseOnly) {
                arrayList.add(rDFObject);
            }
            if ((string = this.getNextNonSpaceToken("Expecting ',' or ')'.")).equals(",") || string.equals(")")) continue;
            throw new SWRLParseException("Expecting ',' or ')', got '" + string + "'.");
        }
        return arrayList;
    }

    private RDFObject parseObject() throws SWRLParseException {
        RDFObject rDFObject = null;
        String string = this.getNextNonSpaceToken("Expecting variable or individual name or literal.");
        if (string.equals("?")) {
            rDFObject = this.parseVariable();
        } else if (this.isValidIndividualName(string)) {
            if (!this.parseOnly) {
                rDFObject = this.getIndividual(string);
            }
        } else {
            rDFObject = this.parseLiteral(string);
        }
        return rDFObject;
    }

    private RDFResource parseIObject() throws SWRLParseException {
        RDFResource rDFResource = null;
        String string = this.getNextNonSpaceToken("Expecting variable or individual name.");
        if (string.equals("?")) {
            rDFResource = this.parseVariable();
        } else {
            if (!this.isValidIndividualName(string) && this.tokenizer.hasMoreTokens()) {
                throw new SWRLParseException("Invalid individual name: '" + string + "'.");
            }
            if (!this.parseOnly) {
                rDFResource = this.getIndividual(string);
            }
        }
        return rDFResource;
    }

    private RDFObject parseDObject() throws SWRLParseException {
        RDFObject rDFObject = null;
        String string = this.getNextNonSpaceToken("Expecting variable or literal.");
        rDFObject = string.equals("?") ? this.parseVariable() : this.parseLiteral(string);
        return rDFObject;
    }

    private RDFResource parseVariable() throws SWRLParseException {
        SWRLVariable sWRLVariable = null;
        String string = this.getNextNonSpaceToken("Expected variable name");
        this.checkThatIdentifierIsValid(string);
        if (this.tokenizer.hasMoreTokens()) {
            if (!this.inHead) {
                this.variables.add(string);
            } else if (!this.variables.contains(string)) {
                throw new SWRLParseException("Variable '" + string + "' referred to in consequent not present in antecedent.");
            }
        }
        if (!this.parseOnly) {
            sWRLVariable = this.getSWRLVariable(string);
        }
        return sWRLVariable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RDFObject parseLiteral(String string) throws SWRLParseException {
        RDFSLiteral rDFSLiteral = null;
        if (string.equals("\"")) {
            String string2 = this.getNextStringToken("Expected a string.");
            if (!this.parseOnly) {
                rDFSLiteral = this.owlModel.createRDFSLiteral(string2, this.owlModel.getXSDstring());
            }
        } else {
            if (string.startsWith("t") || string.startsWith("T") || string.startsWith("f") || string.startsWith("F")) {
                if (!this.tokenizer.hasMoreTokens()) return rDFSLiteral;
                if (!string.equalsIgnoreCase("true")) {
                    if (!string.equalsIgnoreCase("false")) throw new SWRLParseException("Invalid literal '" + string + "'.");
                }
                if (this.parseOnly) return rDFSLiteral;
                return this.owlModel.createRDFSLiteral(string, this.owlModel.getXSDboolean());
            }
            try {
                int n = Integer.parseInt(string);
                if (this.parseOnly) return rDFSLiteral;
                return this.owlModel.createRDFSLiteral(string, this.owlModel.getXSDint());
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    float f = Float.parseFloat(string);
                    if (this.parseOnly) return rDFSLiteral;
                    return this.owlModel.createRDFSLiteral(string, this.owlModel.getXSDfloat());
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        double d = Double.parseDouble(string);
                        if (this.parseOnly) return rDFSLiteral;
                        return this.owlModel.createRDFSLiteral(string, this.owlModel.getXSDdouble());
                    }
                    catch (NumberFormatException numberFormatException3) {
                        try {
                            long l = Long.parseLong(string);
                            if (this.parseOnly) return rDFSLiteral;
                            return this.owlModel.createRDFSLiteral(string, this.owlModel.getXSDlong());
                        }
                        catch (Exception exception) {
                            throw new SWRLParseException("Invalid literal '" + string + "'.");
                        }
                    }
                }
            }
        }
        this.checkAndSkipToken("\"", "Expected \" to close string.");
        return rDFSLiteral;
    }

    private void checkThatVariableNameIsValid(String string) throws SWRLParseException {
        this.checkThatIdentifierIsValid(string);
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource != null && !(rDFResource instanceof SWRLVariable)) {
            throw new SWRLParseException("Invalid variable name: '" + string + "'. Cannot use name of existing OWL class, property, or individual.");
        }
    }

    private boolean isSameAs(String string) throws SWRLParseException {
        return string.equalsIgnoreCase("sameAs");
    }

    private boolean isDifferentFrom(String string) throws SWRLParseException {
        return string.equalsIgnoreCase("differentFrom");
    }

    private boolean isOWLClassName(String string) throws SWRLParseException {
        return this.owlModel.getRDFResource(string) instanceof RDFSNamedClass;
    }

    private boolean isOWLObjectPropertyName(String string) throws SWRLParseException {
        return this.owlModel.getRDFResource(string) instanceof OWLObjectProperty;
    }

    private boolean isOWLDatatypePropertyName(String string) throws SWRLParseException {
        return this.owlModel.getRDFResource(string) instanceof OWLDatatypeProperty;
    }

    private boolean isBuiltinName(String string) throws SWRLParseException {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        return rDFResource != null && rDFResource.getProtegeType().getName().equals("swrl:Builtin");
    }

    private boolean isXSDDatatype(String string) throws SWRLParseException {
        return string.startsWith("xsd:") && this.xmlSchemaSymbols.contains(string.substring(4));
    }

    private void checkThatIdentifierIsValid(String string) throws SWRLParseException {
        if (!this.isValidIdentifier(string)) {
            throw new SWRLParseException("Invalid identifier: '" + string + "'.");
        }
    }

    private boolean isValidIdentifier(String string) {
        if (string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == ':' || c == '-') continue;
            return false;
        }
        return true;
    }

    private boolean isValidIndividualName(String string) throws SWRLParseException {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource == null) {
            return false;
        }
        return rDFResource instanceof OWLIndividual;
    }

    private RDFResource getIndividual(String string) throws SWRLParseException {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource == null) {
            throw new SWRLParseException("'" + string + "' is not a valid individual name");
        }
        if (rDFResource instanceof SWRLVariable) {
            throw new SWRLParseException("'" + string + "' is the name of an OWL individual representing a SWRL variable - " + "it cannot be referenced directly in a SWRL rule");
        }
        return rDFResource;
    }

    private SWRLVariable getSWRLVariable(String string) throws SWRLParseException {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource instanceof SWRLVariable) {
            return (SWRLVariable)rDFResource;
        }
        if (rDFResource == null) {
            return this.swrlFactory.createVariable(string);
        }
        throw new SWRLParseException(string + " cannot be used as a variable name");
    }
}

