/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.SWRLUtil;
import java.util.Set;

public class DefaultSWRLBuiltinAtom
extends DefaultSWRLAtom
implements SWRLBuiltinAtom {
    public DefaultSWRLBuiltinAtom(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultSWRLBuiltinAtom() {
    }

    public void getReferencedInstances(Set set) {
        SWRLBuiltin sWRLBuiltin;
        RDFList rDFList = this.getArguments();
        if (rDFList != null) {
            for (int i = rDFList.size(); i > 0; --i) {
                Object object = rDFList.getFirst();
                if (object instanceof RDFResource) {
                    set.add(object);
                }
                rDFList = rDFList.getRest();
            }
        }
        if ((sWRLBuiltin = this.getBuiltin()) != null) {
            set.add(sWRLBuiltin);
        }
    }

    public RDFList getArguments() {
        return (RDFList)this.getPropertyValue(this.getOWLModel().getRDFProperty("swrl:arguments"));
    }

    public void setArguments(RDFList rDFList) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty("swrl:arguments"), rDFList);
    }

    public SWRLBuiltin getBuiltin() {
        return (SWRLBuiltin)this.getPropertyValue(this.getOWLModel().getRDFProperty("swrl:builtin"));
    }

    public void setBuiltin(SWRLBuiltin sWRLBuiltin) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty("swrl:builtin"), sWRLBuiltin);
    }

    public String getBrowserText() {
        String string = "";
        if (this.getBuiltin() == null || this.getArguments() == null) {
            return super.getBrowserText();
        }
        string = string + this.getBuiltin().getBrowserText() + "(";
        RDFList rDFList = this.getArguments();
        for (int i = rDFList.size(); i > 0; --i) {
            Object object = rDFList.getFirst();
            if (object instanceof RDFResource) {
                string = string + ((RDFResource)object).getBrowserText();
            } else {
                RDFSLiteral rDFSLiteral = rDFList.getFirstLiteral();
                string = string + SWRLUtil.getSWRLBrowserText(rDFSLiteral);
            }
            rDFList = rDFList.getRest();
            if (rDFList.size() <= 0) continue;
            string = string + ", ";
        }
        string = string + ")";
        return string;
    }
}

