/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.factory;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultSimpleInstance;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLVariable;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;

public class SWRLJavaFactory
extends OWLJavaFactory {
    private OWLModel owlModel;
    private static Hashtable classNames = new Hashtable();
    private HashMap classMap = new HashMap();
    private static final String CLASSNAME_PREFIX = "edu.stanford.smi.protegex.owl.swrl.model.impl.Default";

    public SWRLJavaFactory(OWLModel oWLModel) {
        super((AbstractOWLModel)oWLModel);
        this.owlModel = oWLModel;
        this.classMap.put("swrl:Atom", DefaultSWRLAtom.class);
        this.classMap.put("swrl:BuiltinAtom", DefaultSWRLBuiltinAtom.class);
        this.classMap.put("swrl:ClassAtom", DefaultSWRLClassAtom.class);
        this.classMap.put("swrl:DataRangeAtom", DefaultSWRLDataRangeAtom.class);
        this.classMap.put("swrl:DatavaluedPropertyAtom", DefaultSWRLDatavaluedPropertyAtom.class);
        this.classMap.put("swrl:DifferentIndividualsAtom", DefaultSWRLDifferentIndividualsAtom.class);
        this.classMap.put("swrl:IndividualPropertyAtom", DefaultSWRLIndividualPropertyAtom.class);
        this.classMap.put("swrl:SameIndividualAtom", DefaultSWRLSameIndividualAtom.class);
        this.classMap.put("swrl:Builtin", DefaultSWRLBuiltin.class);
        this.classMap.put("swrl:Imp", DefaultSWRLImp.class);
        this.classMap.put("swrl:Variable", DefaultSWRLVariable.class);
        this.classMap.put("swrl:AtomList", DefaultSWRLAtomList.class);
    }

    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection) {
        Object[] objectArray = new Object[]{this.owlModel, frameID};
        if (collection.size() == 1) {
            Cls cls = (Cls)collection.iterator().next();
            String string = cls.getName();
            Class clazz = (Class)this.classMap.get(string);
            if (clazz == null) {
                Iterator iterator = cls.getSuperclasses().iterator();
                while (clazz == null && iterator.hasNext()) {
                    Frame frame = (Frame)iterator.next();
                    clazz = (Class)this.classMap.get(frame.getName());
                }
            }
            if (clazz != null) {
                try {
                    Constructor constructor = clazz.getConstructor(KnowledgeBase.class, FrameID.class);
                    return (SimpleInstance)constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    System.err.println("Fatal Error: Could not create SimpleInstance from OWL metaclass " + clazz.getName());
                    Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                    return new DefaultSimpleInstance((KnowledgeBase)this.owlModel, frameID);
                }
            }
        }
        return super.createSimpleInstance(frameID, collection);
    }

    public Cls createCls(FrameID frameID, Collection collection) {
        Cls cls;
        Class[] classArray = new Class[]{KnowledgeBase.class, FrameID.class};
        Object[] objectArray = new Object[]{this.owlModel, frameID};
        if (collection.size() == 1 && (cls = (Cls)this.classMap.get(collection.iterator().next())) != null) {
            String string = cls.getName();
            String string2 = (String)classNames.get(string);
            try {
                if (string2 != null) {
                    Class<?> clazz = Class.forName(CLASSNAME_PREFIX + string2);
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    return (Cls)constructor.newInstance(objectArray);
                }
            }
            catch (Exception exception) {
                System.err.println("Fatal Error: Could not create Cls from OWL metaclass " + string2);
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                return new DefaultOWLNamedClass(this.owlModel, frameID);
            }
        }
        return super.createCls(frameID, collection);
    }

    private Cls createCls(String string, FrameID frameID) {
        try {
            Class<?> clazz = Class.forName(CLASSNAME_PREFIX + string);
            Class[] classArray = new Class[]{KnowledgeBase.class, FrameID.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.owlModel, frameID};
            return (Cls)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            System.err.println("Fatal Error: Could not create Cls from OWL metaclass " + string);
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return new DefaultOWLNamedClass(this.owlModel, frameID);
        }
    }

    public boolean isCorrectJavaImplementationClass(FrameID frameID, Collection collection, Class clazz) {
        return false;
    }

    static {
        classNames.put("swrl:Atom", "SWRLAtom");
        classNames.put("swrl:BuiltinAtom", "SWRLBuiltinAtom");
        classNames.put("swrl:ClassAtom", "SWRLClassAtom");
        classNames.put("swrl:DataRangeAtom", "SWRLDataRangeAtom");
        classNames.put("swrl:DatavaluedPropertyAtom", "SWRLDataValuedPropertyAtom");
        classNames.put("swrl:DifferentIndividualsAtom", "SWRLDifferentIndividualsAtom");
        classNames.put("swrl:IndividualPropertyAtom", "SWRLIndividualPropertyAtom");
        classNames.put("swrl:SameIndividualAtom", "SWRLSameIndividualAtom");
        classNames.put("swrl:Builtin", "SWRLBuiltin");
        classNames.put("swrl:Imp", "SWRLImp");
        classNames.put("swrl:Variable", "SWRLVariable");
        classNames.put("swrl:AtomList", "SWRLAtomList");
    }
}

