/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class SWRLFactory {
    private OWLNamedClass atomListCls;
    private OWLNamedClass builtinAtomCls;
    private OWLNamedClass classAtomCls;
    private OWLNamedClass dataRangeAtomCls;
    private OWLNamedClass dataValuedPropertyAtomCls;
    private OWLNamedClass differentIndividualsAtomCls;
    private OWLNamedClass impCls;
    private OWLNamedClass individualPropertyAtom;
    private OWLModel owlModel;
    private OWLNamedClass sameIndividualAtomCls;

    public SWRLFactory(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.atomListCls = oWLModel.getOWLNamedClass("swrl:AtomList");
        this.builtinAtomCls = oWLModel.getOWLNamedClass("swrl:BuiltinAtom");
        this.classAtomCls = oWLModel.getOWLNamedClass("swrl:ClassAtom");
        this.dataRangeAtomCls = oWLModel.getOWLNamedClass("swrl:DataRangeAtom");
        this.dataValuedPropertyAtomCls = oWLModel.getOWLNamedClass("swrl:DatavaluedPropertyAtom");
        this.differentIndividualsAtomCls = oWLModel.getOWLNamedClass("swrl:DifferentIndividualsAtom");
        this.impCls = oWLModel.getOWLNamedClass("swrl:Imp");
        this.individualPropertyAtom = oWLModel.getOWLNamedClass("swrl:IndividualPropertyAtom");
        this.sameIndividualAtomCls = oWLModel.getOWLNamedClass("swrl:SameIndividualAtom");
        SWRLJavaFactory sWRLJavaFactory = new SWRLJavaFactory(oWLModel);
        oWLModel.setOWLJavaFactory(sWRLJavaFactory);
        if (oWLModel instanceof JenaOWLModel) {
            OWLJavaFactoryUpdater.run((JenaOWLModel)oWLModel);
        }
    }

    public SWRLImp createImp() {
        String string = this.getNewImpName();
        return (SWRLImp)this.impCls.createInstance(string);
    }

    public SWRLImp createImp(String string) throws SWRLParseException {
        SWRLParser sWRLParser = new SWRLParser(this.owlModel);
        sWRLParser.setParseOnly(false);
        return sWRLParser.parse(string);
    }

    public SWRLImp createImp(SWRLAtom sWRLAtom, Collection collection) {
        SWRLAtomList sWRLAtomList = this.createAtomList(Collections.singleton(sWRLAtom));
        SWRLAtomList sWRLAtomList2 = this.createAtomList(collection);
        return this.createImp(sWRLAtomList, sWRLAtomList2);
    }

    public SWRLImp createImp(SWRLAtomList sWRLAtomList, SWRLAtomList sWRLAtomList2) {
        SWRLImp sWRLImp = this.createImp();
        sWRLImp.setHead(sWRLAtomList);
        sWRLImp.setBody(sWRLAtomList2);
        return sWRLImp;
    }

    public SWRLAtomList createAtomList() {
        return (SWRLAtomList)this.atomListCls.createAnonymousInstance();
    }

    public SWRLAtomList createAtomList(Collection collection) {
        SWRLAtomList sWRLAtomList = this.createAtomList();
        for (Object e : collection) {
            sWRLAtomList.append(e);
        }
        return sWRLAtomList;
    }

    public SWRLBuiltinAtom createBuiltinAtom(SWRLBuiltin sWRLBuiltin, Iterator iterator) {
        RDFList rDFList = this.owlModel.createRDFList(iterator);
        return this.createBuiltinAtom(sWRLBuiltin, rDFList);
    }

    public SWRLBuiltinAtom createBuiltinAtom(SWRLBuiltin sWRLBuiltin, RDFList rDFList) {
        SWRLBuiltinAtom sWRLBuiltinAtom = (SWRLBuiltinAtom)this.builtinAtomCls.createAnonymousInstance();
        sWRLBuiltinAtom.setBuiltin(sWRLBuiltin);
        sWRLBuiltinAtom.setArguments(rDFList);
        return sWRLBuiltinAtom;
    }

    public SWRLClassAtom createClassAtom(RDFSNamedClass rDFSNamedClass, RDFResource rDFResource) {
        SWRLClassAtom sWRLClassAtom = (SWRLClassAtom)this.classAtomCls.createAnonymousInstance();
        sWRLClassAtom.setClassPredicate(rDFSNamedClass);
        sWRLClassAtom.setArgument1(rDFResource);
        return sWRLClassAtom;
    }

    public SWRLDataRangeAtom createDataRangeAtom(RDFResource rDFResource, RDFObject rDFObject) {
        SWRLDataRangeAtom sWRLDataRangeAtom = (SWRLDataRangeAtom)this.dataRangeAtomCls.createAnonymousInstance();
        sWRLDataRangeAtom.setArgument1(rDFObject);
        sWRLDataRangeAtom.setDataRange(rDFResource);
        return sWRLDataRangeAtom;
    }

    public SWRLDatavaluedPropertyAtom createDatavaluedPropertyAtom(OWLDatatypeProperty oWLDatatypeProperty, RDFResource rDFResource, RDFObject rDFObject) {
        SWRLDatavaluedPropertyAtom sWRLDatavaluedPropertyAtom = (SWRLDatavaluedPropertyAtom)this.dataValuedPropertyAtomCls.createAnonymousInstance();
        sWRLDatavaluedPropertyAtom.setPropertyPredicate(oWLDatatypeProperty);
        sWRLDatavaluedPropertyAtom.setArgument1(rDFResource);
        sWRLDatavaluedPropertyAtom.setArgument2(rDFObject);
        return sWRLDatavaluedPropertyAtom;
    }

    public SWRLIndividualPropertyAtom createIndividualPropertyAtom(OWLObjectProperty oWLObjectProperty, RDFResource rDFResource, RDFResource rDFResource2) {
        SWRLIndividualPropertyAtom sWRLIndividualPropertyAtom = (SWRLIndividualPropertyAtom)this.individualPropertyAtom.createAnonymousInstance();
        sWRLIndividualPropertyAtom.setPropertyPredicate(oWLObjectProperty);
        sWRLIndividualPropertyAtom.setArgument1(rDFResource);
        sWRLIndividualPropertyAtom.setArgument2(rDFResource2);
        return sWRLIndividualPropertyAtom;
    }

    public SWRLDifferentIndividualsAtom createDifferentIndividualsAtom(RDFResource rDFResource, RDFResource rDFResource2) {
        SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom = (SWRLDifferentIndividualsAtom)this.differentIndividualsAtomCls.createAnonymousInstance();
        sWRLDifferentIndividualsAtom.setArgument1(rDFResource);
        sWRLDifferentIndividualsAtom.setArgument2(rDFResource2);
        return sWRLDifferentIndividualsAtom;
    }

    public SWRLSameIndividualAtom createSameIndividualAtom(RDFResource rDFResource, RDFResource rDFResource2) {
        SWRLSameIndividualAtom sWRLSameIndividualAtom = (SWRLSameIndividualAtom)this.sameIndividualAtomCls.createAnonymousInstance();
        sWRLSameIndividualAtom.setArgument1(rDFResource);
        sWRLSameIndividualAtom.setArgument2(rDFResource2);
        return sWRLSameIndividualAtom;
    }

    public SWRLVariable createVariable(String string) {
        return (SWRLVariable)this.owlModel.getRDFSNamedClass("swrl:Variable").createInstance(string);
    }

    public SWRLBuiltin createBuiltin(String string) {
        return (SWRLBuiltin)this.owlModel.getRDFSNamedClass("swrl:Builtin").createInstance(string);
    }

    public SWRLBuiltin getBuiltin(String string) {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource instanceof SWRLBuiltin) {
            return (SWRLBuiltin)rDFResource;
        }
        System.err.println("[SWRLFactory]  Invalid attempt to cast " + string + " into SWRLBuiltin (real type is " + rDFResource.getProtegeType() + ")");
        return null;
    }

    public Collection getBuiltins() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass("swrl:Builtin");
        return rDFSNamedClass.getInstances(true);
    }

    public Collection getImps() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass("swrl:Imp");
        return rDFSNamedClass.getInstances(true);
    }

    public String getNewImpName() {
        String string = "Rule-";
        int n = Math.max(1, this.impCls.getInstances(false).size());
        while (this.owlModel.getRDFResource(string + n) != null) {
            ++n;
        }
        return string + n;
    }

    public SWRLVariable getVariable(String string) {
        return (SWRLVariable)this.owlModel.getRDFResource(string);
    }

    public Collection getVariables() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass("swrl:Variable");
        return rDFSNamedClass.getInstances(true);
    }
}

