/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins;

import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentNumberException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.LiteralConversionException;
import java.util.List;

public class SWRLBuiltInUtil {
    public static boolean isExpectingAssignment(String string, List list) {
        return !list.isEmpty() && list.get(0) == null;
    }

    public static void checkNumberOfArgumentsEqualTo(String string, int n, int n2) throws InvalidBuiltInArgumentNumberException {
        if (n != n2) {
            throw new InvalidBuiltInArgumentNumberException(string, n, n2);
        }
    }

    public static void checkNumberOfArgumentsAtLeast(String string, int n, int n2) throws InvalidBuiltInArgumentNumberException {
        if (n2 < n) {
            throw new InvalidBuiltInArgumentNumberException(string, n, n2, "at least");
        }
    }

    public static void checkNumberOfArgumentsAtMost(String string, int n, int n2) throws InvalidBuiltInArgumentNumberException {
        if (n2 > n) {
            throw new InvalidBuiltInArgumentNumberException(string, n, n2, "at most");
        }
    }

    public static void checkThatAllArgumentsAreLiterals(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsALiteral(string, i, list);
        }
    }

    public static void checkThatAllArgumentsAreNumeric(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsNumeric(string, i, list);
        }
    }

    public static void checkThatAllArgumentsAreIntegers(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsAnInteger(string, i, list);
        }
    }

    public static boolean areAllArgumentsIntegers(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentAnInteger(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsLongs(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentALong(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsDoubles(String string, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentADouble(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsBooleans(String string, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentABoolean(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentLiterals(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentALiteral(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsFloats(String string, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentAFloat(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsNumeric(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentNumeric(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsStrings(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentAString(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsOfAnOrderedType(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentOfAnOrderedType(i, list)) continue;
            return false;
        }
        return true;
    }

    public static void checkThatAllArgumentsAreFloats(String string, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsAFloat(string, i, list);
        }
    }

    public static void checkThatAllArgumentsAreStrings(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsAString(string, i, list);
        }
    }

    public static void checkThatAllArgumentsAreOfAnOrderedType(String string, List list) throws InvalidBuiltInArgumentException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsOfAnOrderedType(string, i, list);
        }
    }

    public static void checkThatArgumentIsALiteral(String string, int n, List list) throws InvalidBuiltInArgumentException {
        if (!(list.get(n) instanceof LiteralInfo)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting literal");
        }
    }

    public static void checkThatArgumentIsNumeric(String string, int n, List list) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentNumeric(n, list)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting numeric literal");
        }
    }

    public static void checkThatArgumentIsOfAnOrderedType(String string, int n, List list) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentOfAnOrderedType(n, list)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting ordered type");
        }
    }

    public static boolean isArgumentOfAnOrderedType(int n, List list) throws InvalidBuiltInArgumentException {
        return SWRLBuiltInUtil.isArgumentNumeric(n, list) || SWRLBuiltInUtil.isArgumentAString(n, list);
    }

    public static void checkThatArgumentIsAnIndividualName(String string, int n, List list) throws InvalidBuiltInArgumentException {
        if (!(list.get(n) instanceof IndividualInfo)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting individual name");
        }
    }

    public static boolean isArgumentNumeric(int n, List list) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isNumeric();
        }
        return false;
    }

    public static boolean isArgumentNonNumeric(int n, List list) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return !SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isNumeric();
        }
        return false;
    }

    public static void checkThatArgumentIsNonNumeric(String string, int n, List list) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentNonNumeric(n, list)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting non-numeric literal");
        }
    }

    public static void checkThatArgumentIsAnInteger(String string, int n, List list) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentAnInteger(n, list)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting integer literal");
        }
    }

    public static boolean isArgumentAnInteger(int n, List list) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isInteger();
        }
        return false;
    }

    public static int getArgumentAsAnInteger(String string, int n, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        SWRLBuiltInUtil.checkThatArgumentIsAnInteger(string, n, list);
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getInt();
    }

    public static boolean isArgumentALiteral(int n, List list) {
        return list.get(n) instanceof LiteralInfo;
    }

    public static LiteralInfo getArgumentAsALiteral(int n, List list) throws InvalidBuiltInArgumentException {
        return (LiteralInfo)list.get(n);
    }

    public static void checkThatArgumentIsALong(String string, int n, List list) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentALong(n, list)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting long literal");
        }
    }

    public static boolean isArgumentALong(int n, List list) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isLong();
        }
        return false;
    }

    public static long getArgumentAsALong(String string, int n, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        SWRLBuiltInUtil.checkThatArgumentIsALong(string, n, list);
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getLong();
    }

    public static void checkThatArgumentIsAFloat(String string, int n, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        if (!SWRLBuiltInUtil.isArgumentAFloat(n, list)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting float literal");
        }
    }

    public static boolean isArgumentAFloat(int n, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isFloat();
        }
        return false;
    }

    public static float getArgumentAsAFloat(String string, int n, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        SWRLBuiltInUtil.checkThatArgumentIsAFloat(string, n, list);
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getFloat();
    }

    public static void checkThatArgumentIsADouble(String string, int n, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        if (!SWRLBuiltInUtil.isArgumentADouble(n, list)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting float literal");
        }
    }

    public static boolean isArgumentADouble(int n, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isDouble();
        }
        return false;
    }

    public static double getArgumentAsADouble(String string, int n, List list) throws InvalidBuiltInArgumentException, LiteralConversionException {
        SWRLBuiltInUtil.checkThatArgumentIsADouble(string, n, list);
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getDouble();
    }

    public static void checkThatArgumentIsABoolean(String string, int n, List list) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentABoolean(n, list)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting boolean literal");
        }
    }

    public static boolean isArgumentABoolean(int n, List list) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isBoolean();
        }
        return false;
    }

    public static boolean getArgumentAsABoolean(String string, int n, List list) throws InvalidBuiltInArgumentException {
        SWRLBuiltInUtil.checkThatArgumentIsABoolean(string, n, list);
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getBoolean();
    }

    public static void checkThatArgumentIsAString(String string, int n, List list) throws InvalidBuiltInArgumentException {
        if (!SWRLBuiltInUtil.isArgumentAString(n, list)) {
            throw new InvalidBuiltInArgumentException(string, n, "Expecting string literal");
        }
    }

    public static boolean isArgumentAString(int n, List list) throws InvalidBuiltInArgumentException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isString();
        }
        return false;
    }

    public static String getArgumentAsAString(String string, int n, List list) throws InvalidBuiltInArgumentException {
        SWRLBuiltInUtil.checkThatArgumentIsAString(string, n, list);
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getString();
    }
}

