/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.bridge.ui.SWRLRuleEngineGUIAdapter;
import edu.stanford.smi.protegex.owl.swrl.ui.tab.SWRLTab;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SWRLRuleEngineManager {
    private static HashMap registeredRuleEngines = new HashMap();
    private static String visibleRuleEngineName = "";
    private static ProjectListener projectListener = new ProjectAdapter(){

        public void projectClosed(ProjectEvent projectEvent) {
            Project project = (Project)projectEvent.getSource();
            project.removeProjectListener(projectListener);
            visibleRuleEngineName = "";
        }
    };

    public static void registerRuleEngine(String string, String string2, Icon icon, SWRLRuleEngineGUIAdapter sWRLRuleEngineGUIAdapter) {
        if (registeredRuleEngines.containsKey(string)) {
            registeredRuleEngines.remove(string);
        }
        registeredRuleEngines.put(string, new RuleEngineRegistrationInfo(string, string2, icon, sWRLRuleEngineGUIAdapter));
        System.err.println("Registering " + string + " rule engine with SWRL bridge.");
    }

    public static Collection getRegisteredRuleEngines() {
        return registeredRuleEngines.values();
    }

    public static void unregisterEngine(String string) {
        if (registeredRuleEngines.containsKey(string)) {
            if (SWRLRuleEngineManager.isVisible(string)) {
                SWRLRuleEngineManager.hideRuleEngine(string, true);
            }
            registeredRuleEngines.remove(string);
        }
    }

    public static boolean isVisible(String string) {
        return !visibleRuleEngineName.equals("") && string.equals(visibleRuleEngineName);
    }

    public static void showRuleEngine(String string, SWRLTab sWRLTab, OWLModel oWLModel) {
        oWLModel.getProject().addProjectListener(projectListener);
        if (!SWRLRuleEngineManager.isVisible(string) && SWRLRuleEngineManager.hideRuleEngine(visibleRuleEngineName) && registeredRuleEngines.containsKey(string)) {
            RuleEngineRegistrationInfo ruleEngineRegistrationInfo = (RuleEngineRegistrationInfo)registeredRuleEngines.get(string);
            Container container = ruleEngineRegistrationInfo.getGUIAdapter().createRuleEngineGUI(oWLModel);
            if (container != null) {
                sWRLTab.add(container);
                sWRLTab.setVisible(false);
                sWRLTab.setVisible(true);
                visibleRuleEngineName = string;
            } else {
                SWRLRuleEngineManager.makeTextPanel(sWRLTab, "Unable to activate the " + string + " rule engine.");
            }
        }
    }

    public static void hideVisibleRuleEngine() {
        SWRLRuleEngineManager.hideRuleEngine(visibleRuleEngineName, true);
    }

    public static boolean hideRuleEngine(String string) {
        return SWRLRuleEngineManager.hideRuleEngine(string, false);
    }

    private static boolean hideRuleEngine(String string, boolean bl) {
        if (SWRLRuleEngineManager.isVisible(string)) {
            if (!bl && JOptionPane.showConfirmDialog(null, "Do you really want to disable the " + string + " rule engine?", "Disable " + string, 0) != 0) {
                return false;
            }
            if (registeredRuleEngines.containsKey(string)) {
                RuleEngineRegistrationInfo ruleEngineRegistrationInfo = (RuleEngineRegistrationInfo)registeredRuleEngines.get(string);
                Container container = ruleEngineRegistrationInfo.getGUIAdapter().getRuleEngineGUI();
                Container container2 = container.getParent();
                container2.remove(container);
                container2.setVisible(false);
                container2.setVisible(true);
                visibleRuleEngineName = "";
            }
        }
        return true;
    }

    private static void makeTextPanel(SWRLTab sWRLTab, String string) {
        JPanel jPanel = new JPanel(false);
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jLabel);
        sWRLTab.add(jPanel);
    }

    static {
        try {
            Class.forName("edu.stanford.smi.protegex.owl.swrl.bridge.jess.ui.SWRLJessTab");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find the edu.stanford.smi.protegex.owl.swrl.bridge.jess.ui.SWRLJessTab class");
        }
    }

    public static class RuleEngineRegistrationInfo {
        private String ruleEngineName;
        private String toolTip;
        private SWRLRuleEngineGUIAdapter guiAdapter;
        private Icon icon;

        public RuleEngineRegistrationInfo(String string, String string2, Icon icon, SWRLRuleEngineGUIAdapter sWRLRuleEngineGUIAdapter) {
            this.ruleEngineName = string;
            this.toolTip = string2;
            this.guiAdapter = sWRLRuleEngineGUIAdapter;
            this.icon = icon;
        }

        public String getRuleEngineName() {
            return this.ruleEngineName;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public SWRLRuleEngineGUIAdapter getGUIAdapter() {
            return this.guiAdapter;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

