/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidClassNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import java.util.ArrayList;
import java.util.List;

public class ClassInfo
extends Info {
    private List directSuperClassNames;
    private List directSubClassNames;

    public ClassInfo(OWLModel oWLModel, String string) throws SWRLRuleEngineBridgeException {
        super(string);
        OWLNamedClass oWLNamedClass = oWLModel.getOWLNamedClass(string);
        if (oWLNamedClass == null) {
            throw new InvalidClassNameException(string);
        }
        if (string.equals("owl:Thing")) {
            this.directSuperClassNames = new ArrayList();
            this.directSubClassNames = new ArrayList();
        } else {
            this.directSuperClassNames = ClassInfo.rdfResources2NamesList(oWLNamedClass.getNamedSuperclasses());
            this.directSubClassNames = ClassInfo.rdfResources2NamesList(oWLNamedClass.getNamedSubclasses());
        }
    }

    public List getDirectSuperClassNames() {
        return this.directSuperClassNames;
    }

    public List getDirectSubClassNames() {
        return this.directSubClassNames;
    }

    public String toString() {
        return "Class(name: " + this.getName() + ", directSubClassNames: " + this.directSubClassNames + ", directSuperClassNames: " + this.directSuperClassNames + ")";
    }
}

