/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.AtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.VariableInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import java.util.ArrayList;
import java.util.List;

public class BuiltInAtomInfo
extends AtomInfo {
    private List arguments;

    public BuiltInAtomInfo(OWLModel oWLModel, SWRLBuiltinAtom sWRLBuiltinAtom) throws SWRLRuleEngineBridgeException {
        super(sWRLBuiltinAtom.getBuiltin().getName());
        this.arguments = this.buildInfoList(oWLModel, sWRLBuiltinAtom);
    }

    public List getArguments() {
        return this.arguments;
    }

    public boolean isFirstArgumentAVariable() {
        return !this.arguments.isEmpty() && this.arguments.get(0) instanceof VariableInfo;
    }

    public String getFirstArgumentVariableName() throws SWRLRuleEngineBridgeException {
        if (!this.isFirstArgumentAVariable()) {
            throw new SWRLRuleEngineBridgeException("Expecting a variable as the first parameter of built-in '" + this.getName() + "'");
        }
        return ((VariableInfo)this.arguments.get(0)).getName();
    }

    private List buildInfoList(OWLModel oWLModel, SWRLBuiltinAtom sWRLBuiltinAtom) throws SWRLRuleEngineBridgeException {
        ArrayList<Info> arrayList = new ArrayList<Info>();
        RDFList rDFList = sWRLBuiltinAtom.getArguments();
        for (Object e : rDFList.getValues()) {
            OWLIndividual oWLIndividual;
            if (e instanceof SWRLVariable) {
                oWLIndividual = (SWRLVariable)e;
                arrayList.add(new VariableInfo((SWRLVariable)oWLIndividual));
                this.addReferencedVariableName(oWLIndividual.getName());
                continue;
            }
            if (e instanceof OWLIndividual) {
                oWLIndividual = (OWLIndividual)e;
                arrayList.add(new IndividualInfo(oWLIndividual));
                this.addReferencedIndividualName(oWLIndividual.getName());
                continue;
            }
            if (e instanceof RDFSLiteral) {
                arrayList.add(new LiteralInfo(oWLModel, (RDFSLiteral)e));
                continue;
            }
            if (e instanceof Number) {
                arrayList.add(new LiteralInfo((Number)e));
                continue;
            }
            if (e instanceof String) {
                arrayList.add(new LiteralInfo((String)e));
                continue;
            }
            throw new SWRLRuleEngineBridgeException("Unknown type for parameter '" + e + "' to built-in atom '" + sWRLBuiltinAtom.getBrowserText() + "'.");
        }
        return arrayList;
    }
}

