/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.storage;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.storage.KnowledgeBaseCopier;
import java.util.Collection;
import java.util.HashSet;

public class ProtegeSaver
extends KnowledgeBaseCopier {
    private OWLModel owlModel;

    public ProtegeSaver(KnowledgeBase knowledgeBase, OWLModel oWLModel) {
        super(knowledgeBase, oWLModel);
        this.owlModel = oWLModel;
    }

    protected void addExtraDirectTypes(Instance instance, Instance instance2) {
        super.addExtraDirectTypes(instance, instance2);
        if (instance instanceof Slot && !((Slot)instance).getAllowsMultipleValues() && instance2 instanceof RDFProperty) {
            ((RDFProperty)instance2).setFunctional(true);
        }
    }

    protected Collection cloneValues(Collection collection) {
        Collection collection2 = super.cloneValues(collection);
        return new HashSet(collection2);
    }

    protected Cls createCls(String string, Cls cls) {
        String string2 = this.getValidName(string);
        this.log("+ Creating named class " + string2 + " for " + string + " with type " + cls.getName());
        OWLNamedClass oWLNamedClass = this.owlModel.createOWLNamedClass(string2, (OWLNamedClass)cls);
        String string3 = oWLNamedClass.getName();
        if (!string3.equals(string)) {
            oWLNamedClass.addLabel(string, null);
        }
        return oWLNamedClass;
    }

    protected Instance createInstance(String string, Cls cls) {
        RDFIndividual rDFIndividual;
        String string2;
        String string3 = this.getValidName(string);
        Instance instance = super.createInstance(string3, cls);
        if (instance instanceof RDFIndividual && !(string2 = (rDFIndividual = (RDFIndividual)instance).getName()).equals(string)) {
            rDFIndividual.addLabel(string, null);
        }
        return instance;
    }

    protected Slot createSlot(String string, ValueType valueType) {
        String string2 = this.getValidName(string);
        this.log("+ Creating slot " + string2);
        RDFProperty rDFProperty = null;
        rDFProperty = valueType == ValueType.INSTANCE || valueType == ValueType.CLS ? this.owlModel.createOWLObjectProperty(string2) : (valueType == ValueType.ANY ? this.owlModel.createRDFProperty(string2) : this.owlModel.createOWLDatatypeProperty(string2));
        rDFProperty.removeUnionDomainClass(this.owlModel.getOWLThingClass());
        String string3 = rDFProperty.getName();
        if (!string3.equals(string)) {
            rDFProperty.addLabel(string, null);
        }
        return rDFProperty;
    }

    protected Cls getNewCls(Cls cls) {
        if (cls.getName().equals(":STANDARD-CLASS")) {
            return this.owlModel.getOWLNamedClassClass();
        }
        if (cls.getName().equals(":STANDARD-SLOT")) {
            return this.owlModel.getRDFPropertyClass();
        }
        if (cls.getName().equals(":THING")) {
            return this.owlModel.getOWLThingClass();
        }
        return super.getNewCls(cls);
    }

    protected Slot getNewSlot(Slot slot) {
        if (slot.getName().equals(":DOCUMENTATION")) {
            return this.owlModel.getRDFSCommentProperty();
        }
        if (slot.getName().equals(":DIRECT-SUPERSLOTS")) {
            return this.owlModel.getRDFSSubPropertyOfProperty();
        }
        if (slot.getName().equals(":SLOT-INVERSE")) {
            return this.owlModel.getRDFProperty("owl:inverseOf");
        }
        return super.getNewSlot(slot);
    }

    private String getValidName(String string) {
        string = string.replace(':', '_');
        String string2 = AbstractOWLModel.getValidOWLFrameName((AbstractOWLModel)this.owlModel, string);
        int n = 1;
        while (this.owlModel.getFrame(string2) != null) {
            string2 = AbstractOWLModel.getValidOWLFrameName((AbstractOWLModel)this.owlModel, string + n);
            ++n;
        }
        return string2;
    }

    protected void setDirectType(Instance instance, Instance instance2) {
        if (instance instanceof Slot && instance2 instanceof OWLProperty) {
            return;
        }
        super.setDirectType(instance, instance2);
    }

    protected void setInitialOwnSlotValues(Instance instance) {
        super.setInitialOwnSlotValues(instance);
        if (instance instanceof Slot) {
            Slot slot = (Slot)instance;
            Slot slot2 = slot.getInverseSlot();
            Slot slot3 = (Slot)this.getNewInstance((Instance)slot);
            if (slot2 != null && slot3 != null) {
                Slot slot4 = (Slot)this.getNewInstance((Instance)slot2);
                slot3.setInverseSlot(slot4);
            }
        }
    }

    protected void setValueType(Slot slot, Slot slot2) {
        ValueType valueType = slot.getValueType();
        if (valueType != ValueType.ANY) {
            if (slot2 instanceof RDFProperty && (valueType == ValueType.BOOLEAN || valueType == ValueType.FLOAT || valueType == ValueType.INTEGER || valueType == ValueType.STRING)) {
                String string = XMLSchemaDatatypes.getDefaultXSDDatatype(valueType).getURI();
                RDFSDatatype rDFSDatatype = this.owlModel.getRDFSDatatypeByURI(string);
                ((RDFProperty)slot2).setRange(rDFSDatatype);
            }
            super.setValueType(slot, slot2);
        } else {
            System.err.println("[ProtegeSaver] Warning: Slot " + slot + " has value type ANY");
        }
    }
}

