/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protegex.owl.repository.util.XMLBaseExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class OntologyNameExtractor {
    private InputStream is;
    private URI uri;
    private URL url;
    private boolean rdfRootPresent;

    public OntologyNameExtractor(InputStream inputStream, URL uRL) {
        this.is = inputStream;
        this.url = uRL;
        this.uri = null;
        this.rdfRootPresent = false;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.is != null) {
            try {
                XMLBaseExtractor xMLBaseExtractor = new XMLBaseExtractor(this.is);
                this.uri = xMLBaseExtractor.getXMLBase();
                String string = xMLBaseExtractor.getRootElementName();
                if (string != null) {
                    this.rdfRootPresent = string.toLowerCase().equals("rdf:rdf");
                } else {
                    this.uri = null;
                }
            }
            finally {
                this.is = null;
            }
        }
    }

    public boolean isRDFRootElementPresent() {
        return this.rdfRootPresent;
    }

    public URI getOntologyName() throws IOException {
        return this.uri;
    }
}

