/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.RelativeFolderRepository;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;

public class RelativeFolderRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    public boolean isSuitable(OWLModel oWLModel, String string) {
        if (oWLModel.getProject() != null && oWLModel.getProject().getProjectURI() != null) {
            try {
                URI uRI = new URI(string.trim());
                return !uRI.isAbsolute();
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
        }
        return false;
    }

    public Repository createRepository(OWLModel oWLModel, String string) {
        try {
            return new RelativeFolderRepository(oWLModel.getProject().getProjectURI().toURL(), string.trim());
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
        return null;
    }
}

