/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protegex.owl.repository.impl.LocalFolderRepository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class RelativeFolderRepository
extends LocalFolderRepository {
    private String relativeURL;

    public RelativeFolderRepository(URL uRL, String string) throws MalformedURLException, URISyntaxException {
        this(uRL, string, RepositoryUtil.isForcedToBeReadOnly(RelativeFolderRepository.getURI(uRL, string).getQuery()));
    }

    public RelativeFolderRepository(URL uRL, String string, boolean bl) throws MalformedURLException, URISyntaxException {
        super(new File(RelativeFolderRepository.getURI(uRL, string).getPath()), bl);
        this.relativeURL = RelativeFolderRepository.stripQuery(string);
    }

    private static URI getURI(URL uRL, String string) throws MalformedURLException, URISyntaxException {
        return new URI(new URL(uRL, string).toString());
    }

    private static String stripQuery(String string) {
        int n = string.indexOf(63);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public String getRepositoryDescriptor() {
        try {
            URI uRI = new URI(this.relativeURL);
            return uRI.toString() + "?" + "forceReadOnly" + "=" + this.isForceReadOnly();
        }
        catch (URISyntaxException uRISyntaxException) {
            return "";
        }
    }

    public String getRepositoryDescription() {
        return "Relative URL: " + this.relativeURL + "  (" + this.getFile().toString() + ")";
    }
}

