/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFileRepository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class LocalFileRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    public boolean isSuitable(OWLModel oWLModel, String string) {
        if (string.trim().startsWith("file:")) {
            try {
                File file = new File(new URI(string).getPath());
                return file.isFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
        }
        return false;
    }

    public Repository createRepository(OWLModel oWLModel, String string) {
        try {
            URI uRI = new URI(string);
            File file = new File(uRI.getPath());
            return new LocalFileRepository(file, RepositoryUtil.isForcedToBeReadOnly(uRI.getQuery()));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

