/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactory;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTTPRepository
implements Repository {
    private static transient Logger log = Log.getLogger(HTTPRepository.class);
    private URL ontologyURL;
    private URI ontologyName;

    public HTTPRepository(URL uRL) {
        this.ontologyURL = uRL;
        this.ontologyName = null;
        this.update();
    }

    public String getRepositoryDescriptor() {
        return this.ontologyURL.toString();
    }

    public String getOntologyLocationDescription(URI uRI) {
        String string = "";
        if (this.ontologyName.equals(uRI)) {
            string = this.ontologyURL.toString();
        }
        return string;
    }

    private void update() {
        try {
            PrintStream printStream = System.err;
            System.setErr(new PrintStream(new OutputStream(){

                public void write(int n) throws IOException {
                }
            }));
            InputStream inputStream = ProtegeOWLParser.getInputStream(this.ontologyURL);
            OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(inputStream, this.ontologyURL);
            this.ontologyName = ontologyNameExtractor.getOntologyName();
            System.setErr(printStream);
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public boolean isSystem() {
        return false;
    }

    public URL getOntologyURL() {
        return this.ontologyURL;
    }

    public boolean contains(URI uRI) {
        if (this.ontologyName != null) {
            return this.ontologyName.equals(uRI);
        }
        return false;
    }

    public void refresh() {
        this.update();
    }

    public Collection getOntologies() {
        if (this.ontologyName != null) {
            return Collections.singleton(this.ontologyName);
        }
        return Collections.EMPTY_LIST;
    }

    public URL getLocation(URI uRI) {
        if (uRI == null) {
            return null;
        }
        if (uRI.equals(this.ontologyName)) {
            return this.ontologyURL;
        }
        return null;
    }

    public InputStream getInputStream(URI uRI) throws IOException {
        return ProtegeOWLParser.getInputStream(this.ontologyURL);
    }

    public boolean isWritable(URI uRI) {
        try {
            File file = new File(new URI(this.ontologyURL.toString()));
            return file.canWrite();
        }
        catch (Exception exception) {
            Log.emptyCatchBlock((Throwable)exception);
            return false;
        }
    }

    public OutputStream getOutputStream(URI uRI) throws IOException {
        FileOutputStream fileOutputStream = null;
        if (this.isWritable(uRI)) {
            try {
                File file = new File(new URI(this.ontologyURL.toString()));
                fileOutputStream = new FileOutputStream(file);
            }
            catch (URISyntaxException uRISyntaxException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
            }
        }
        return fileOutputStream;
    }

    public String getRepositoryDescription() {
        return "URL";
    }

    static {
        RepositoryFactory repositoryFactory = RepositoryFactory.getInstance();
        repositoryFactory.registerRepositoryFactoryPlugin(new HTTPRepositoryFactoryPlugin());
    }
}

