/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DuplicateSuperclassesPostProcessor;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.OWLAnonymousClassPostProcessor;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.OWLDeprecatedClassPostProcessor;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.RDFListPostProcessor;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.RDFPropertyPostProcessor;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.RDFSNamedClassPostProcessor;

public class TripleChangePostProcessor {
    public static void postProcess(OWLModel oWLModel) {
        TripleStore tripleStore = oWLModel.getTripleStoreModel().getActiveTripleStore();
        long l = System.currentTimeMillis();
        new RDFListPostProcessor(oWLModel);
        TripleChangePostProcessor.log("Completed lists after " + (System.currentTimeMillis() - l) + " ms");
        l = System.currentTimeMillis();
        new OWLAnonymousClassPostProcessor(oWLModel);
        TripleChangePostProcessor.log("Completed anonymous classes after " + (System.currentTimeMillis() - l) + " ms");
        l = System.currentTimeMillis();
        new OWLDeprecatedClassPostProcessor(oWLModel);
        TripleChangePostProcessor.log("Completed deprecated classes after " + (System.currentTimeMillis() - l) + " ms");
        l = System.currentTimeMillis();
        new RDFPropertyPostProcessor(oWLModel);
        TripleChangePostProcessor.log("Completed properties after " + (System.currentTimeMillis() - l) + " ms");
        l = System.currentTimeMillis();
        new RDFSNamedClassPostProcessor(oWLModel);
        new DuplicateSuperclassesPostProcessor(oWLModel);
        TripleChangePostProcessor.log("Completed named classes after " + (System.currentTimeMillis() - l) + " ms");
        oWLModel.getTripleStoreModel().setActiveTripleStore(tripleStore);
    }

    private static void log(String string) {
        Log.getLogger().info("[TripleChangePostProcessor] " + string);
    }
}

