/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TripleStoreUtil {
    public static void addToTripleStore(OWLModel oWLModel, TripleStore tripleStore, RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        TripleStore tripleStore2 = oWLModel.getTripleStoreModel().getActiveTripleStore();
        if (tripleStore2 != tripleStore) {
            oWLModel.getTripleStoreModel().setActiveTripleStore(tripleStore);
            rDFResource.addPropertyValue(rDFProperty, object);
            oWLModel.getTripleStoreModel().setActiveTripleStore(tripleStore2);
        } else {
            rDFResource.addPropertyValue(rDFProperty, object);
        }
    }

    public static TripleStore ensureActiveTripleStore(RDFResource rDFResource) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        if (tripleStoreModel != null) {
            TripleStore tripleStore = tripleStoreModel.getHomeTripleStore(rDFResource);
            tripleStoreModel.setActiveTripleStore(tripleStore);
            return tripleStore;
        }
        return null;
    }

    public static RDFResource getFirstOntology(OWLModel oWLModel, TripleStore tripleStore) {
        OWLNamedClass oWLNamedClass = oWLModel.getOWLOntologyClass();
        Iterator iterator = tripleStore.listSubjects(oWLModel.getRDFTypeProperty(), oWLNamedClass);
        if (iterator.hasNext()) {
            Frame frame = (Frame)iterator.next();
            if (frame instanceof RDFResource) {
                return (RDFResource)frame;
            }
            return new DefaultOWLOntology(oWLModel, frame.getFrameID());
        }
        return null;
    }

    public static TripleStore getTripleStoreOf(RDFResource rDFResource, Slot slot, Object object) {
        if (rDFResource.getOWLModel() instanceof OWLDatabaseModel) {
            return rDFResource.getOWLModel().getTripleStoreModel().getTopTripleStore();
        }
        if (object instanceof RDFSLiteral) {
            object = ((DefaultRDFSLiteral)object).getRawValue();
        }
        OWLModel oWLModel = rDFResource.getOWLModel();
        for (TripleStore tripleStore : oWLModel.getTripleStoreModel().getTripleStores()) {
            if (!tripleStore.getNarrowFrameStore().getValues((Frame)rDFResource, slot, null, false).contains(object)) continue;
            return tripleStore;
        }
        return null;
    }

    public static Iterator listDependingTriples(RDFResource rDFResource) {
        ArrayList arrayList = new ArrayList();
        TripleStoreUtil.getDependingTriples(rDFResource, arrayList);
        return arrayList.iterator();
    }

    private static void getDependingTriples(RDFResource rDFResource, List list) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        Iterator iterator = oWLModel.getTripleStoreModel().listTriplesWithSubject(rDFResource);
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            list.add(triple);
            if (!(triple.getObject() instanceof RDFResource)) continue;
            RDFResource rDFResource2 = (RDFResource)triple.getObject();
            if (rDFResource2.isAnonymous()) {
                TripleStoreUtil.getDependingTriples(rDFResource2, list);
                continue;
            }
            RDFSClass rDFSClass = rDFResource2.getRDFType();
            if (rDFSClass == null) continue;
            DefaultTriple defaultTriple = new DefaultTriple(rDFResource2, oWLModel.getRDFTypeProperty(), rDFSClass);
            list.add(defaultTriple);
        }
    }

    public static void moveResources(Collection collection, TripleStore tripleStore, TripleStore tripleStore2) {
        if (!collection.isEmpty()) {
            OWLModel oWLModel = ((RDFResource)collection.iterator().next()).getOWLModel();
            NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
            NarrowFrameStore narrowFrameStore2 = tripleStore2.getNarrowFrameStore();
            Collection collection2 = oWLModel.getSlots();
            for (RDFResource rDFResource : collection) {
                TripleStoreUtil.moveResource(rDFResource, collection2, narrowFrameStore, narrowFrameStore2);
            }
            oWLModel.flushCache();
        }
    }

    private static void moveResource(Instance instance, Collection collection, NarrowFrameStore narrowFrameStore, NarrowFrameStore narrowFrameStore2) {
        for (Slot slot : collection) {
            List list = narrowFrameStore.getValues((Frame)instance, slot, null, false);
            for (Object e : list) {
                narrowFrameStore.removeValue((Frame)instance, slot, null, false, e);
            }
            narrowFrameStore2.addValues((Frame)instance, slot, null, false, (Collection)list);
        }
    }

    public static void replaceTriple(final Triple triple, final Triple triple2) {
        OWLModel oWLModel = triple.getSubject().getOWLModel();
        TripleStore tripleStore = TripleStoreUtil.getTripleStoreOf(triple.getSubject(), triple.getPredicate(), triple.getObject());
        TripleStoreUtil.runInTripleStore(oWLModel, tripleStore, new Runnable(){

            public void run() {
                triple.getSubject().removePropertyValue(triple.getPredicate(), triple.getObject());
                triple2.getSubject().addPropertyValue(triple2.getPredicate(), triple2.getObject());
            }
        });
    }

    public static void runInHomeTripleStoreOf(RDFResource rDFResource, Runnable runnable) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        TripleStore tripleStore = oWLModel.getTripleStoreModel().getHomeTripleStore(rDFResource);
        TripleStoreUtil.runInTripleStore(oWLModel, tripleStore, runnable);
    }

    public static void runInTripleStore(OWLModel oWLModel, TripleStore tripleStore, Runnable runnable) {
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        TripleStore tripleStore2 = tripleStoreModel.getActiveTripleStore();
        if (tripleStore2 != tripleStore && tripleStore != null) {
            tripleStoreModel.setActiveTripleStore(tripleStore);
            runnable.run();
            tripleStoreModel.setActiveTripleStore(tripleStore2);
        } else {
            runnable.run();
        }
    }

    public static void sortSlotValues(NarrowFrameStore narrowFrameStore, Instance instance, Slot slot, Comparator comparator) {
        List list = narrowFrameStore.getValues((Frame)instance, slot, null, false);
        if (!list.isEmpty()) {
            ArrayList arrayList = new ArrayList(list);
            Collections.sort(arrayList, comparator);
            narrowFrameStore.setValues((Frame)instance, slot, null, false, arrayList);
        }
    }

    public static void sortSubclasses(OWLModel oWLModel) {
        NarrowFrameStore narrowFrameStore;
        TripleStore tripleStore;
        Object object2;
        Slot slot = oWLModel.getSlot(":DIRECT-SUBCLASSES");
        Collection collection = oWLModel.getUserDefinedRDFSNamedClasses();
        for (Object object2 : collection) {
            tripleStore = oWLModel.getTripleStoreModel().getHomeTripleStore((RDFResource)object2);
            narrowFrameStore = tripleStore.getNarrowFrameStore();
            TripleStoreUtil.sortSlotValues(narrowFrameStore, (Instance)object2, slot, (Comparator)new FrameComparator());
        }
        OWLNamedClass oWLNamedClass = oWLModel.getOWLThingClass();
        object2 = oWLModel.getTripleStoreModel().listUserTripleStores();
        while (object2.hasNext()) {
            tripleStore = (TripleStore)object2.next();
            narrowFrameStore = tripleStore.getNarrowFrameStore();
            TripleStoreUtil.sortSlotValues(narrowFrameStore, oWLNamedClass, slot, (Comparator)new FrameComparator());
        }
        oWLModel.flushCache();
    }

    public static void switchTripleStore(OWLModel oWLModel, TripleStore tripleStore) {
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        if (tripleStoreModel.getActiveTripleStore() != tripleStore) {
            WaitCursor waitCursor = new WaitCursor(ProtegeUI.getTopLevelContainer(oWLModel.getProject()));
            tripleStoreModel.setActiveTripleStore(tripleStore);
            tripleStoreModel.updateEditableResourceState();
            ProtegeUI.reloadUI(oWLModel.getProject());
            waitCursor.hide();
        }
    }

    public static void updateFrameInclusion(MergingNarrowFrameStore mergingNarrowFrameStore, Slot slot) {
        NarrowFrameStore narrowFrameStore = mergingNarrowFrameStore.getActiveFrameStore();
        TripleStoreUtil.updateFrameInclusion(narrowFrameStore, slot, false);
        NarrowFrameStore narrowFrameStore2 = mergingNarrowFrameStore.getSystemFrameStore();
        for (NarrowFrameStore narrowFrameStore3 : mergingNarrowFrameStore.getAllFrameStores()) {
            if (narrowFrameStore3 == narrowFrameStore2 || narrowFrameStore3 == narrowFrameStore) continue;
            TripleStoreUtil.updateFrameInclusion(narrowFrameStore3, slot, true);
        }
    }

    private static void updateFrameInclusion(NarrowFrameStore narrowFrameStore, Slot slot, boolean bl) {
        for (Frame frame : narrowFrameStore.getFrames()) {
            if (frame.isSystem() || narrowFrameStore.getValuesCount(frame, slot, null, false) <= 0) continue;
            frame.setIncluded(bl);
            frame.setEditable(!bl);
        }
    }
}

