/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.QuantifierRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.util.Collection;
import java.util.Collections;

class AllValuesFromRestrictionUpdater
extends QuantifierRestrictionUpdater {
    private Cls metaCls;
    private Facet valueTypeFacet;

    AllValuesFromRestrictionUpdater(AbstractOWLModel abstractOWLModel) {
        super(abstractOWLModel);
        this.metaCls = abstractOWLModel.getCls("owl:AllValuesFromRestriction");
        this.valueTypeFacet = abstractOWLModel.getFacet(":VALUE-TYPE");
    }

    private void addAllRestriction(Cls cls, RDFProperty rDFProperty, Cls cls2) {
        OWLAllValuesFrom oWLAllValuesFrom = this.owlModel.createOWLAllValuesFrom(rDFProperty, (RDFSClass)cls2);
        cls.addDirectSuperclass((Cls)oWLAllValuesFrom);
        this.log("+ OWLAllValuesFrom " + oWLAllValuesFrom.getBrowserText() + " to " + cls.getName() + "." + rDFProperty.getName());
    }

    protected void clearFiller(OWLQuantifierRestriction oWLQuantifierRestriction) {
        this.owlModel.setTemplateSlotAllowedClses(oWLQuantifierRestriction, oWLQuantifierRestriction.getOnProperty(), Collections.EMPTY_LIST);
    }

    public void copyFacetValuesIntoNamedClass(RDFSNamedClass rDFSNamedClass, OWLRestriction oWLRestriction) {
        RDFProperty rDFProperty = oWLRestriction.getOnProperty();
        this.updateValueTypeFacet(rDFSNamedClass, rDFProperty);
    }

    private void removeValueTypeOverride(RDFSNamedClass rDFSNamedClass, Slot slot) {
        if (slot != null && rDFSNamedClass.hasDirectlyOverriddenTemplateFacet(slot, this.valueTypeFacet)) {
            rDFSNamedClass.setTemplateSlotAllowedClses(slot, Collections.EMPTY_LIST);
            rDFSNamedClass.setTemplateFacetValues(slot, this.valueTypeFacet, Collections.EMPTY_LIST);
            this.log("- Removed :VALUE-TYPE override from " + rDFSNamedClass.getName() + "." + slot.getName());
        }
    }

    private void setAllowedClses(RDFSNamedClass rDFSNamedClass, Slot slot, Collection collection) {
        this.log("+ Setting allowed clses of " + rDFSNamedClass.getName() + "." + slot.getName());
        for (Cls cls : collection) {
            this.log("  - " + cls.getBrowserText());
        }
        rDFSNamedClass.setTemplateSlotAllowedClses(slot, collection);
    }

    private void setAllowedValues(RDFSNamedClass rDFSNamedClass, Slot slot, Collection collection) {
        this.log("+ Setting allowed values of " + rDFSNamedClass.getName() + "." + slot.getName());
        for (Object e : collection) {
            this.log("  - " + e);
        }
        rDFSNamedClass.setTemplateSlotAllowedValues(slot, collection);
    }

    protected void updateAllRestrictions(Cls cls, RDFProperty rDFProperty) {
        if (cls.hasDirectlyOverriddenTemplateFacet((Slot)rDFProperty, this.valueTypeFacet)) {
            ValueType valueType = cls.getTemplateSlotValueType((Slot)rDFProperty);
            if (valueType == ValueType.INSTANCE) {
                Collection collection = cls.getTemplateSlotAllowedClses((Slot)rDFProperty);
                if (collection.size() == 0) {
                    this.removeRestrictions(cls, rDFProperty, this.metaCls);
                    this.addAllRestriction(cls, rDFProperty, this.owlModel.createOWLEnumeratedClass());
                } else {
                    this.ensureNoSurvivingClsesAreDeleted(cls, rDFProperty, collection, this.metaCls);
                    if (collection.size() == 1) {
                        Cls cls2 = (Cls)collection.iterator().next();
                        this.removeRestrictions(cls, rDFProperty, this.metaCls);
                        this.addAllRestriction(cls, rDFProperty, cls2);
                    } else {
                        OWLUnionClass oWLUnionClass = this.owlModel.createOWLUnionClass(collection);
                        this.removeRestrictions(cls, rDFProperty, this.metaCls);
                        this.addAllRestriction(cls, rDFProperty, oWLUnionClass);
                    }
                }
            } else if (valueType != ValueType.SYMBOL && valueType != ValueType.CLS) {
                this.removeRestrictions(cls, rDFProperty, this.metaCls);
                RDFSDatatype rDFSDatatype = this.owlModel.getRDFSDatatypeByURI(XMLSchemaDatatypes.getDefaultXSDDatatype(valueType).getURI());
                OWLAllValuesFrom oWLAllValuesFrom = this.owlModel.createOWLAllValuesFrom(rDFProperty, rDFSDatatype);
                cls.addDirectSuperclass((Cls)oWLAllValuesFrom);
                this.log("+ OWLAllValuesFrom " + oWLAllValuesFrom.getBrowserText() + " to " + cls.getName() + "." + rDFProperty.getName());
            }
        } else {
            this.removeRestrictions(cls, rDFProperty, this.metaCls);
        }
    }

    public void updateRestrictions(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, Facet facet) {
        this.updateAllRestrictions(oWLNamedClass, rDFProperty);
    }

    void updateValueTypeFacet(RDFSNamedClass rDFSNamedClass, Slot slot) {
        if (slot != null) {
            Collection collection = this.getDirectRestrictions(rDFSNamedClass, slot, OWLAllValuesFrom.class);
            if (collection.size() == 1) {
                OWLQuantifierRestriction oWLQuantifierRestriction = (OWLQuantifierRestriction)collection.toArray()[0];
                this.updateValueTypeFacet(rDFSNamedClass, slot, oWLQuantifierRestriction);
            } else {
                this.removeValueTypeOverride(rDFSNamedClass, slot);
            }
        }
    }

    private void updateValueTypeFacet(RDFSNamedClass rDFSNamedClass, Slot slot, OWLQuantifierRestriction oWLQuantifierRestriction) {
        Collection collection;
        Collection collection2;
        ValueType valueType;
        ValueType valueType2 = valueType = rDFSNamedClass.getTemplateSlotValueType(slot);
        Collection collection3 = collection2 = rDFSNamedClass.getTemplateSlotAllowedClses(slot);
        Collection collection4 = collection = rDFSNamedClass.getTemplateSlotAllowedValues(slot);
        RDFResource rDFResource = oWLQuantifierRestriction.getFiller();
        if (rDFResource instanceof RDFSClass) {
            RDFSClass rDFSClass = (RDFSClass)rDFResource;
            if ("rdfs:Literal".equals(rDFSClass.getName())) {
                valueType2 = ValueType.ANY;
            } else {
                valueType2 = ValueType.INSTANCE;
                collection3 = this.getQuantifierClsClses(rDFSClass);
            }
        } else if (rDFResource instanceof OWLDataRange) {
            collection4 = ((OWLDataRange)rDFResource).getOneOf().getValues();
            valueType2 = ValueType.SYMBOL;
        } else {
            RDFSDatatype rDFSDatatype = (RDFSDatatype)rDFResource;
            if (rDFSDatatype.equals(this.owlModel.getRDFXMLLiteralType())) {
                valueType2 = ValueType.STRING;
            } else {
                String string = XMLSchemaDatatypes.getXSDDatatype(rDFSDatatype).getURI();
                valueType2 = XMLSchemaDatatypes.getValueType(string);
            }
        }
        if (valueType == valueType2) {
            if (valueType2 == ValueType.INSTANCE && !((Object)collection2).equals(collection3)) {
                this.setAllowedClses(rDFSNamedClass, slot, collection3);
            } else if (valueType2 == ValueType.SYMBOL && !((Object)collection).equals(collection4)) {
                this.setAllowedValues(rDFSNamedClass, slot, collection4);
            }
        } else {
            this.log("+ Setting :VALUE-TYPE of " + rDFSNamedClass.getName() + "." + slot.getName() + " to " + valueType2);
            rDFSNamedClass.setTemplateSlotValueType(slot, valueType2);
            if (valueType2 == ValueType.INSTANCE) {
                this.setAllowedClses(rDFSNamedClass, slot, collection3);
            } else if (valueType2 == ValueType.SYMBOL) {
                this.setAllowedValues(rDFSNamedClass, slot, collection4);
            }
        }
    }
}

