/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.triplestore;

import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.triplestore.JenaTripleStore;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractTripleStoreModel;
import java.util.ArrayList;
import java.util.Collection;

public class JenaTripleStoreModel
extends AbstractTripleStoreModel {
    private JenaOWLModel owlModel;

    public JenaTripleStoreModel(JenaOWLModel jenaOWLModel) {
        super(jenaOWLModel);
        this.owlModel = jenaOWLModel;
        this.initTripleStores();
    }

    public JenaTripleStoreModel(JenaOWLModel jenaOWLModel, NarrowFrameStore narrowFrameStore) {
        super(jenaOWLModel);
        this.owlModel = jenaOWLModel;
        this.ts.add(new JenaTripleStore((OWLModel)jenaOWLModel, narrowFrameStore, this));
        jenaOWLModel.resetJenaModel();
    }

    public TripleStore createTripleStore(String string) {
        InMemoryFrameDb inMemoryFrameDb = new InMemoryFrameDb(string);
        String string2 = this.getActiveTripleStore().getName();
        this.mnfs.addActiveChildFrameStore((NarrowFrameStore)inMemoryFrameDb, string2);
        JenaTripleStore jenaTripleStore = new JenaTripleStore((OWLModel)this.owlModel, (NarrowFrameStore)inMemoryFrameDb, this);
        this.ts.add(jenaTripleStore);
        this.updateRemoveFrameStores();
        return jenaTripleStore;
    }

    public void deleteTripleStore(TripleStore tripleStore) {
        this.ts.remove(tripleStore);
    }

    public static void ensureActiveTripleStore(RDFResource rDFResource) {
        TripleStoreUtil.ensureActiveTripleStore(rDFResource);
    }

    public TripleStore getTripleStoreByDefaultNamespace(String string) {
        for (TripleStore tripleStore : this.ts) {
            if (!string.equals(tripleStore.getDefaultNamespace())) continue;
            return tripleStore;
        }
        return null;
    }

    private void initTripleStores() {
        this.ts = new ArrayList();
        NarrowFrameStore[] narrowFrameStoreArray = this.mnfs.getAvailableFrameStores().toArray(new NarrowFrameStore[0]);
        for (int i = 0; i < narrowFrameStoreArray.length; ++i) {
            NarrowFrameStore narrowFrameStore = narrowFrameStoreArray[i];
            this.ts.add(new JenaTripleStore((OWLModel)this.owlModel, narrowFrameStore, this));
        }
        this.updateRemoveFrameStores();
    }

    private void updateRemoveFrameStores() {
        Collection collection = this.mnfs.getAvailableFrameStores();
        this.mnfs.setRemoveFrameStores(collection);
        this.owlModel.resetJenaModel();
    }
}

