/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.importer;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class OWLImporter {
    private KnowledgeBase kb;
    private OWLModel owlModel;

    public OWLImporter(OWLModel oWLModel, KnowledgeBase knowledgeBase) {
        this.owlModel = oWLModel;
        this.kb = knowledgeBase;
        this.importClses();
        this.importSlots();
        this.importInstances();
        this.updateSlotDomain();
    }

    private void createAllowedClses(Slot slot, Slot slot2) {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        for (RDFSNamedClass rDFSNamedClass : slot.getAllowedClses()) {
            Cls cls = this.getCls(rDFSNamedClass);
            if (cls == null) continue;
            arrayList.add(cls);
        }
        slot2.setAllowedClses(arrayList);
    }

    private void createAllowedParents(Slot slot, Slot slot2) {
        RDFProperty rDFProperty = this.owlModel.getProtegeAllowedParentProperty();
        if (rDFProperty != null) {
            ArrayList<Cls> arrayList = new ArrayList<Cls>();
            for (RDFSNamedClass rDFSNamedClass : slot.getDirectOwnSlotValues((Slot)rDFProperty)) {
                Cls cls = this.getCls(rDFSNamedClass);
                if (cls == null) continue;
                arrayList.add(cls);
            }
            slot2.setAllowedParents(arrayList);
        }
    }

    private Cls createCls(Cls cls) {
        Cls cls2 = this.getCls(cls.getDirectType());
        Cls cls3 = this.kb.createCls(cls.getName(), (Collection)Collections.EMPTY_LIST, cls2);
        this.log("+ Created Cls " + cls.getName());
        cls3.setAbstract(cls.isAbstract());
        this.createDirectSuperclasses(cls, cls3);
        this.createDirectTemplateSlots(cls, cls3);
        this.createDirectOwnSlotValues((Instance)cls, (Instance)cls3);
        return cls3;
    }

    private void createDirectOwnSlotValues(Instance instance, Instance instance2) {
        for (Slot slot : instance.getOwnSlots()) {
            Slot slot2;
            if (!this.isRelevantOwnSlot(slot) || (slot2 = this.getSlot(slot)) == null) continue;
            this.createDirectOwnSlotValues(instance, instance2, slot, slot2);
        }
    }

    private void createDirectOwnSlotValues(Instance instance, Instance instance2, Slot slot, Slot slot2) {
        for (Object e : instance.getDirectOwnSlotValues(slot)) {
            Object object = this.getNewValue(e);
            if (object == null) continue;
            instance2.addOwnSlotValue(slot2, object);
        }
    }

    private void createDirectSuperclasses(Cls cls, Cls cls2) {
        for (Cls cls3 : cls.getDirectSuperclasses()) {
            if (!(cls3 instanceof RDFSNamedClass)) continue;
            Cls cls4 = this.getCls((RDFSNamedClass)cls3);
            cls2.addDirectSuperclass(cls4);
        }
    }

    private void createDirectTemplateSlots(Cls cls, Cls cls2) {
        Slot slot;
        for (Slot slot2 : cls.getDirectTemplateSlots()) {
            if (!(slot2 instanceof OWLProperty)) continue;
            slot = this.getSlot((OWLProperty)slot2);
            cls2.addDirectTemplateSlot(slot);
        }
        if (cls instanceof OWLNamedClass) {
            for (Slot slot2 : cls.getTemplateSlots()) {
                if (!(slot2 instanceof RDFProperty) || !this.isRelevantOwnSlot(slot2)) continue;
                slot = this.getSlotForced(slot2);
                this.createDirectTemplateSlotOverloads((OWLNamedClass)cls, cls2, slot2, slot);
            }
        }
    }

    private void createDirectTemplateSlotOverloads(OWLNamedClass oWLNamedClass, Cls cls, Slot slot, Slot slot2) {
        Collection collection = oWLNamedClass.getRestrictions(false);
        for (OWLRestriction oWLRestriction : collection) {
            Object object;
            Object object2;
            if (!oWLRestriction.getOnProperty().equals(slot)) continue;
            cls.addDirectTemplateSlot(slot2);
            if (oWLRestriction instanceof OWLCardinality) {
                int n = ((OWLCardinality)oWLRestriction).getCardinality();
                cls.setTemplateSlotMinimumCardinality(slot2, n);
                cls.setTemplateSlotMaximumCardinality(slot2, n);
                continue;
            }
            if (oWLRestriction instanceof OWLMinCardinality) {
                int n = ((OWLMinCardinality)oWLRestriction).getCardinality();
                cls.setTemplateSlotMinimumCardinality(slot2, n);
                continue;
            }
            if (oWLRestriction instanceof OWLMaxCardinality) {
                int n = ((OWLMaxCardinality)oWLRestriction).getCardinality();
                cls.setTemplateSlotMaximumCardinality(slot2, n);
                continue;
            }
            if (oWLRestriction instanceof OWLAllValuesFrom) {
                OWLAllValuesFrom oWLAllValuesFrom = (OWLAllValuesFrom)oWLRestriction;
                if (slot instanceof OWLDatatypeProperty && oWLAllValuesFrom.getFiller() instanceof RDFSDatatype) {
                    object2 = (RDFSDatatype)oWLAllValuesFrom.getFiller();
                    ValueType valueType = XMLSchemaDatatypes.getValueType(object2.getURI());
                    cls.setTemplateSlotValueType(slot2, valueType);
                    continue;
                }
                if (!(slot instanceof OWLObjectProperty) || !(oWLAllValuesFrom.getFiller() instanceof RDFSNamedClass)) continue;
                object2 = this.getCls((RDFSNamedClass)oWLAllValuesFrom.getFiller());
                cls.setTemplateSlotAllowedClses(slot2, Collections.singleton(object2));
                continue;
            }
            if (!(oWLRestriction instanceof OWLHasValue) || (object2 = this.getNewValue(object = ((OWLHasValue)oWLRestriction).getHasValue())) == null) continue;
            cls.setTemplateSlotValue(slot2, object2);
        }
    }

    private Instance createInstance(Instance instance) {
        Cls cls = instance.getDirectType();
        Cls cls2 = this.getCls(cls);
        Instance instance2 = cls2.createDirectInstance(instance.getName());
        this.log("+ Created instance " + instance.getName());
        this.createDirectOwnSlotValues(instance, instance2);
        return instance2;
    }

    private Slot createSlot(Slot slot) {
        RDFProperty rDFProperty;
        RDFResource rDFResource;
        Cls cls = this.getCls(slot.getDirectType());
        Slot slot2 = this.kb.createSlot(slot.getName(), cls);
        this.log("+ Created slot " + slot.getName());
        if (slot instanceof RDFProperty && !((RDFProperty)slot).isDomainDefined()) {
            this.kb.getRootCls().addDirectTemplateSlot(slot2);
        }
        slot2.setAllowsMultipleValues(slot.getAllowsMultipleValues());
        ValueType valueType = slot.getValueType();
        slot2.setValueType(valueType);
        if (valueType == ValueType.INSTANCE) {
            this.createAllowedClses(slot, slot2);
        } else if (valueType == ValueType.CLS) {
            this.createAllowedParents(slot, slot2);
        } else if (valueType == ValueType.SYMBOL) {
            slot2.setAllowedValues(slot.getAllowedValues());
        }
        if (slot instanceof RDFProperty && (rDFResource = (rDFProperty = (RDFProperty)slot).getRange()) instanceof OWLDataRange) {
            slot2.setValueType(ValueType.SYMBOL);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object e : ((OWLDataRange)rDFResource).getOneOfValues()) {
                arrayList.add(e.toString());
            }
            slot2.setAllowedValues(arrayList);
        }
        this.createDirectOwnSlotValues((Instance)slot, (Instance)slot2);
        if (slot.getInverseSlot() instanceof RDFProperty) {
            rDFProperty = this.getSlot((RDFProperty)slot.getInverseSlot());
            slot2.setInverseSlot((Slot)rDFProperty);
        }
        return slot2;
    }

    private Cls getCls(Cls cls) {
        if (cls.equals(this.owlModel.getOWLThingClass())) {
            return this.kb.getRootCls();
        }
        if (cls.equals(this.owlModel.getRDFSNamedClassClass()) || cls.equals(this.owlModel.getOWLNamedClassClass())) {
            return this.kb.getDefaultClsMetaCls();
        }
        if (cls.getName().equals("rdf:Property") || cls.getName().equals("owl:DatatypeProperty") || cls.getName().equals("owl:ObjectProperty")) {
            return this.kb.getDefaultSlotMetaCls();
        }
        Cls cls2 = this.kb.getCls(cls.getName());
        if (cls2 == null) {
            cls2 = this.createCls(cls);
        }
        return cls2;
    }

    private Instance getInstance(Instance instance) {
        if (instance instanceof Cls) {
            return this.getCls((Cls)instance);
        }
        if (instance instanceof Slot) {
            return this.getSlot((Slot)instance);
        }
        Instance instance2 = this.kb.getInstance(instance.getName());
        if (instance2 == null) {
            instance2 = this.createInstance(instance);
        }
        return instance2;
    }

    private Object getNewValue(Object object) {
        Object object2 = null;
        if (object instanceof RDFResource) {
            object2 = this.getInstance((RDFResource)object);
        } else if (object instanceof Boolean || object instanceof String || object instanceof Number) {
            object2 = object;
        }
        return object2;
    }

    private Slot getSlot(Slot slot) {
        if (!(slot instanceof RDFProperty) || ((RDFProperty)slot).isDomainDefined()) {
            return this.getSlotForced(slot);
        }
        return null;
    }

    private Slot getSlotForced(Slot slot) {
        Slot slot2 = this.kb.getSlot(slot.getName());
        if (slot2 == null) {
            slot2 = this.createSlot(slot);
        }
        return slot2;
    }

    private void importClses() {
        for (RDFSNamedClass rDFSNamedClass : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            this.getCls(rDFSNamedClass);
        }
    }

    private void importInstances() {
        for (RDFSNamedClass rDFSNamedClass : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            for (RDFResource rDFResource : rDFSNamedClass.getInstances(false)) {
                this.getInstance(rDFResource);
            }
        }
    }

    private void importSlots() {
        for (RDFProperty rDFProperty : this.owlModel.getUserDefinedRDFProperties()) {
            if (rDFProperty.isDomainDefined() || !rDFProperty.isEditable()) continue;
            this.getSlotForced(rDFProperty);
        }
    }

    private boolean isRelevantOwnSlot(Slot slot) {
        return slot instanceof RDFProperty && slot.isEditable() && !slot.getName().startsWith("protege:") || ":SLOT-CONSTRAINTS".equals(slot.getName()) || ":PAL-DESCRIPTION".equals(slot.getName()) || ":PAL-NAME".equals(slot.getName()) || ":PAL-RANGE".equals(slot.getName()) || ":PAL-STATEMENT".equals(slot.getName());
    }

    private void log(String string) {
    }

    private void updateSlotDomain() {
        Cls cls = this.kb.getRootCls();
        for (Slot slot : new ArrayList(cls.getDirectTemplateSlots())) {
            if (slot.getDirectDomain().size() <= 1) continue;
            cls.removeDirectTemplateSlot(slot);
        }
    }
}

